variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}

provider "aws" {
  access_key = "${var.twitch_aws_access_key}"
  region = "us-west-2"
  secret_key = "${var.twitch_aws_secret_key}"
}

variable "twitch_environment"{
  default = "prod"
} 

###################################
#         ASG Config Vars         #
###################################
variable "min_size"{
  default = 0
}
variable "max_size"{
  default = 0
}
variable "desired_capacity"{
  default = 0
}
variable "cluster" {
  #default = "datadev"
  description = "The puppet hiera cluster for configuration"
}
variable "owner_tag" {
  default = "d8a <d8a@justin.tv>"
  description = "Tag used on resource tags and names to help locate resources in AWS"
}
variable "project_tag" {
  default = "web/data-dev"
  description = "Tag used on resource tags and names to help locate resources in AWS"
}
variable "subnet_id" {
  #default = "subnet-b1af88d4,subnet-1d76336a,subnet-cbd54a92"
} 


###################################
#         Launch Config Vars      #
###################################
variable "ami" {
  default = "ami-dd11f3bd"
}
variable "aws_account"{
  description = "web-dev,web-aws"
}
variable "instance_name_prefix" {
  default = "datadev"
  description = "The dns name prefix to use -- usually the same as var.cluster"
}
variable "instance_type" {
  default = "c4.8xlarge"
}
variable "root_volume_size" {
  default = "250"
  description = "Root volume size in GB"
}
variable "security_groups" {
  description = "Comma separated list of security group ids"
  #default ="sg-3cd6a958"
}
variable "enable_monitoring"{
  description = "enable detailed monitoring"
}
variable "instance_role"{
    description = "instance role to launch instance with"
}

