variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}

provider "aws" {
  access_key = "${var.twitch_aws_access_key}"
  region = "us-west-2"
  secret_key = "${var.twitch_aws_secret_key}"
}

variable "twitch_dns_access_key" {}
variable "twitch_dns_secret_key" {}
provider "aws" {
  access_key = "${var.twitch_dns_access_key}"
  alias = "twitch_aws"  #this is twitch-aws account(science/r53 account) 2015-10-27
  region = "us-west-2"
  secret_key = "${var.twitch_dns_secret_key}"
}

module "base" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/release/terraform.git//base?ref=terraform07"
}

module "common" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/variables/twitch-web-aws/"
}
module "common_local" {
  source = "../../modules/variables/twitch-web-aws/"
}

variable "asg_name" {
  default = "datadev_prod_asg"
}

variable "lambda_arn" {
  default = "arn:aws:lambda:us-west-2:641044725657:function:asg_route53_update"
}

variable "environment"{
  default = "prod"
}

variable "twitch_environment"{
  default = "production"
}

variable "ami" {
  default = "ami-dd11f3bd"
}

variable "cluster" {
  default = "clio-pgbadger"
  description = "The puppet hiera cluster for configuration"
}

variable "security_groups"{
  default = "sg-9c52bafb"
}

variable "instance_type"{
  default = "c4.8xlarge"
}
variable "env"{
  default = "prod"
}
variable "instance_name_prefix"{
  default = "clio-pgbadger"
}
variable "clio_pgbadger_topic" {
  default = "clio_pgbadger_topic"
}

variable "aws_account" {
  default = "twitch-web-aws"
}
variable "enable_monitoring" {
  default = "true"
}
variable "instance_role"{
  default = "datadev"
}
variable "internal_zone_id" {
  default = "ZRG00SM48517Z"
  description = "us-west2.justin.tv"
}
variable "external_zone_id" {
  default = "ZL2XLO1TDFXZB"
  description = "us-west2.twitch.tv"
}
variable "owner" {
  default = "d8a@twitch.tv"
}
variable "sg_project"{
  default = "clio_pgbouncer"
}

########################
#     Security Group   #
########################

module "d8a_prod_sg_00" {
  source = "../../security_groups/lib/sg.simple.20160606/"
  sg_name = "clio_pgbouncer"
  sg_environment = "${var.environment}"
  sg_description = "clio_pgbouncer"
  vpc_id = "${module.common.vpc_id}"
  vpc_cidr = "${module.common_local.vpc_cidr}"
  twitch_private_subnets = "${module.common_local.twitch_private_subnets}"
  data_cidr = "${module.common_local.data_a_cidr},${module.common_local.data_b_cidr},${module.common_local.data_c_cidr}"
  sg_project = "clio_pgbouncer"
}


#####################################
#      clio_pgbadger 06.06.2016           #
#####################################

module "clio_pgbadger_20160606"{
  twitch_aws_access_key = "${var.twitch_aws_access_key}"
  twitch_aws_secret_key = "${var.twitch_aws_secret_key}"

  ami = "ami-dd11f3bd"
  aws_account = "${var.aws_account}"
  source = "../lib/clio_pgbadger.20160606/"
  instance_type = "${var.instance_type}"
  security_groups = "${module.d8a_prod_sg_00.db_sec_id}"
  instance_name_prefix = "${var.instance_name_prefix}"
  enable_monitoring = "${var.enable_monitoring}"
  cluster = "${var.cluster}"
  twitch_environment = "${var.twitch_environment}"

  ##### IN ROTATION CAPACITY

  max_size = "1"
  min_size = "1"
  desired_capacity = "1"

  subnet_id = "${module.common.data_a},${module.common.data_b},${module.common.data_c}"
  instance_role = "${var.instance_role}"

}

module "notifications_clio_pgbadger_2016_06_06" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/asg-r53-lambda.git//modules/notifications"
  aws_profile = "web"
  topic_name = "${var.clio_pgbadger_topic}_2016_06_06"
  asg_name = "${module.clio_pgbadger_20160606.asg_name}"
  lambda_arn = "${var.lambda_arn}"
}
