variable twitch_aws_access_key {}
variable twitch_aws_secret_key {}
provider "aws" {
  access_key = "${var.twitch_aws_access_key}"
  #alias = "twitch_web_aws"
  region = "us-west-2"
  secret_key = "${var.twitch_aws_secret_key}"
}

variable "comparison_operator"{
  description = "comparison operator to measurea against metric"
  default = ""
}
variable "dimensions"{
  description = "dimensions targetted by alarm"
  default = ""
}
variable "evaluation_periods"{
  description = "evaluation periods"
  default = ""
}
variable "metric_name"{
  description = "metric you are tracking"
  default = ""
}
variable "namespace"{
  description = "namespace of metric"
  default = ""
}
variable "period"{
  description = "period of healthcheck"
  default = ""
}
variable "statistic"{
  description = "statistic of metric"
  default = ""
}
variable "threshold"{
  description = "value of threshold"
  default = ""
}
variable "alarm_description"{
  description = "description of alarm"
  default = ""
}
variable "alarm_actions"{
  description = "what the alarm does when in alarm state"
  default = ""
}
variable "unit"{
  description = "unit of metric"
  default = ""
}
variable "alarm_name" {
  description = "name of the alarm"
  default = ""
}


resource "aws_cloudwatch_metric_alarm" "cloudwatch_metric_alarm" {
    provider = "aws"
    alarm_name = "${var.alarm_name}"
    comparison_operator = "${var.comparison_operator}"
    evaluation_periods = "${var.evaluation_periods}"
    metric_name = "${var.metric_name}"
    namespace = "${var.namespace}"
    period = "${var.period}"
    statistic = "${var.statistic}"
    threshold = "${var.threshold}"
    dimensions =  { InstanceId = "${var.dimensions}" }
    alarm_description = "This metric monitor ec2 DiskSpace utilization on root partition"
    alarm_actions = [ "${var.alarm_actions}" ]
    unit = "Percent"
}
