variable "twitch_dns_access_key" {}
variable "twitch_dns_secret_key" {}
provider "aws" {
  access_key = "${var.twitch_dns_access_key}"
  alias = "twitch_aws"  #this is twitch-aws account(science/r53 account) 2015-10-27
  region = "us-west-2"
  secret_key = "${var.twitch_dns_secret_key}"
}
variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}
provider "aws" {
  access_key = "${var.twitch_aws_access_key}"
  #alias = "twitch_aws" # XXX AGB: terraform fails if this is uncommented. 2015-10-02
  region = "us-west-2"
  secret_key = "${var.twitch_aws_secret_key}"
}

variable "name"{}
variable "env" {}
variable "subnets" {}
variable "security_groups" {}
variable "internal_zone_id" {}
variable "external_zone_id" {}
variable "owner" {}
variable "pg_cluster" {}
variable "cluster" {}
variable "instance_ids" {}
variable "health_check_endpoint" {}

# Create a new load balancer
resource "aws_elb" "internal_elb_pgbouncer" {
  name = "${var.name}"
  subnets = ["${split(",", var.subnets)}"]
  internal = true
  security_groups = ["${var.security_groups}"]

 lifecycle {
    create_before_destroy = true
  }

  listener {
    instance_port = 6543
    instance_protocol = "tcp"
    lb_port = 6543
    lb_protocol = "tcp"
  }

  health_check {
    healthy_threshold = 2
    unhealthy_threshold = 2
    timeout = 3
    target = "${var.health_check_endpoint}"
    interval = 5
  }

  tags {
    Service = "${var.cluster}/${var.pg_cluster}"
    Environment = "${var.env}"
    Owner = "${var.owner}"
  }
  instances = ["${split(",", var.instance_ids)}"]
  cross_zone_load_balancing = true
  connection_draining = true
  connection_draining_timeout = 120
}

resource "aws_route53_record" "elb_internal_r53" {
  provider = "aws.twitch_aws"

  zone_id = "${var.internal_zone_id}"
  name = "${var.name}-internal.${var.env}"
  type = "CNAME"
  ttl = "300"
  records = ["${aws_elb.internal_elb_pgbouncer.dns_name}"]
}

output "internal_elb_pgbouncer_id"{
  value = "${aws_elb.internal_elb_pgbouncer.id}"
}
