variable "name"{}
variable "env" {}
variable "subnets" {}
variable "security_group" {}
variable "internal_zone_id" {}
variable "external_zone_id" {}
variable "owner" {}
variable "pg_cluster" {}
variable "cluster" {}


# Create a new load balancer
resource "aws_elb" "internal_elb_pgbouncer" {
  name = "${var.name}-internal"
  subnets = ["${split(",", var.subnets)}"]
  internal = true
  security_groups = ["${var.security_group}"]

 lifecycle {
    create_before_destroy = true
  }

  listener {
    instance_port = 12005
    instance_protocol = "tcp"
    lb_port = 12005
    lb_protocol = "tcp"
  }

  health_check {
    healthy_threshold = 2
    unhealthy_threshold = 2
    timeout = 3
    target = "HTTP:6545/port/all" # incorrect until we improve pg-healthcheck. could lead to flapping.
    interval = 5
  }

  tags {
    Service = "${var.cluster}/${var.pg_cluster}"
    Environment = "${var.env}"
    Owner = "${var.owner}"
  }

  #instances = ["${split(",", var.instance_ids)}"]
  cross_zone_load_balancing = true
  connection_draining = true
  connection_draining_timeout = 120
}

resource "aws_route53_record" "elb_internal_r53" {
  provider = "aws.dns"

  zone_id = "${var.internal_zone_id}"
  name = "${var.name}-internal.${var.env}"
  type = "CNAME"
  ttl = "300"
  records = ["${aws_elb.internal_elb_pgbouncer.dns_name}"]
}

output "internal_elb_pgbouncer_id"{
  value = "${aws_elb.internal_elb_pgbouncer.id}"
}
