##
# Hardcoded outputs that describe shared resources such as VPC, Subnets, SGs
#
# Intended to be used by services requiring networking information to launch in various web accounts.
# To reference these values, include 'module "common"' in your TF plan.
##

# VPC ID
output "vpc_id" {
    value = "vpc-6183fe04"
}
output "vpc_cidr" {
    value = "10.193.192.0/18"
}

# SUBNET IDS
output "internal_service_a" {
    value = "10.193.192.0/21"
}

output "internal_service_b" {
    value = "10.193.208.0/21"
}

output "internal_service_c" {
    value = "10.193.224.0/21"
}

output "external_service_a" {
    value = "10.193.200.0/22"
}

output "external_service_b" {
    value = "10.193.216.0/22"
}

output "external_service_c" {
    value = "10.193.232.0/22"
}

output "data_a_cidr" {
    value = "10.193.204.0/22"
}

output "data_b_cidr" {
    value = "10.193.220.0/22"
}

output "data_c_cidr" {
    value = "10.193.236.0/22"
}

output "data_a" {
  value = "subnet-a0c197c5"
}

output "data_b" {
  value = "subnet-6d81f51a"
}
output "data_c" {
  value = "subnet-ed3db3b4"
}

# SECURITY GROUPS

output "twitch_private_subnets" {
  value = "10.0.0.0/8,127.0.0.1/32,192.168.0.0/16"
  #value = "10.0.0.0/8,192.168.0.0/16"
}

output "chat_postgres_security_group" {
    value = "sg-63641e07"
}

output "owner" {
    value = "d8a@justin.tv"
}

output "tmi_postgres_security_group" {
  value = "sg-63641e07"
}

output "internal_zone_id" {
  value = "ZRG00SM48517Z"
  # description = "us-west2.justin.tv"
}
output "external_zone_id" {
  value = "ZL2XLO1TDFXZB"
  # description = "us-west2.twitch.tv"
}

output "health_check_endpoint" {
  value = "HTTP:6545/port/6543"
}
