data "template_file" "dbproxy_ud_20180302" {
  template="${file("${path.module}/../templates.20170314/dbproxy.20180302.user_data")}"
  vars {
    aws_account="${var.aws_account}"
    cluster="${var.cluster}"
    hostname_prefix="${var.instance_name_prefix}"
    pg_cluster="${var.pg_cluster}"
    twitch_environment="${var.twitch_environment}"
  }
}

resource "aws_launch_configuration" "dbproxy_lc_20180302" {
  associate_public_ip_address = "false"
  enable_monitoring = "${var.enable_monitoring}"
  iam_instance_profile = "${var.instance_role}"
  image_id = "${var.ami}"
  instance_type = "${var.instance_type}"
  name_prefix = "${var.cluster}.${var.name_env}."
  security_groups = ["${split(",", var.security_groups)}"]
  user_data = "${data.template_file.dbproxy_ud_20180302.rendered}"

  lifecycle {
    create_before_destroy = true
  }
  root_block_device {
    volume_size = "100"
    volume_type = "gp2"
  }
}
