variable "twitch_environment"{
  default = "development"
} 
variable "cluster" {
  #default = "rails-postgres"
  description = "The puppet hiera cluster for configuration"
}
variable "load_balancers"{
  default = ""
} 

###################################
#         ASG Config Vars         #
###################################
variable "min_size"{
  default = 0
}
variable "max_size"{
  default = 0
}
variable "desired_capacity"{
  default = 0
}
variable "owner_tag" {
  default = "d8a <d8a@justin.tv>"
  description = "Tag used on resource tags and names to help locate resources in AWS"
}
variable "project_tag" {
  default = "web/rails-pgbouncer"
  description = "Tag used on resource tags and names to help locate resources in AWS"
}
variable "subnet_id" {
  #default = "subnet-b1af88d4,subnet-1d76336a,subnet-cbd54a92"
}

###################################
#         Launch Config Vars      #
###################################
variable "pg_role" {
  description = "Role of the node in the cluster, eg 'hot-spare'"
  default = "read-replica"
}
variable "ami" {
}
variable "aws_account"{
  description = "web-dev,web-aws"
}
variable "pg_cluster"{
  #default = "zookeeper"
  description = "Things like 'prod', 'replay', etc to uniquely identify the postgres cluster of master and replicas"
}
variable "instance_name_prefix" {
  #default = "rails-postgres-aws"
  description = "The dns name prefix to use -- usually the same as var.cluster"
}
variable "instance_type" {
  default = "m4.xlarge"
}
variable "root_volume_size" {
  default = "250"
  description = "Root volume size in GB"
}
variable "security_groups" {
  description = "Comma separated list of security group ids"
  #default ="sg-3cd6a958"
}
variable "enable_monitoring"{
  description = "enable detailed monitoring"
}
variable "instance_role"{
  description = "instance role to launch instance with"
}
variable "environment"{
  description = "Usually a copy of the twitch_environment"
}
variable "name_env"{
  default = "prod"
  description = "launch config name, eg, prod or dev"
}
