data "template_file" "dbproxy_20170323_ud" {
  template="${file("${path.module}/../templates.20170314/dbproxy.user_data")}"
  vars {
    aws_account="${var.aws_account}"
    cluster="${var.cluster}"
    hostname_prefix="${var.instance_name_prefix}"
    pg_cluster="${var.pg_cluster}"
    twitch_environment="${var.twitch_environment}"
  }
}

resource "aws_launch_configuration" "dbproxy_20170323_lc" {
  associate_public_ip_address = "false"
  enable_monitoring = "${var.enable_monitoring}"
  iam_instance_profile = "${var.instance_role}"
  image_id = "ami-fb41ca9b"
  instance_type = "${var.instance_type}"
  name_prefix = "rails-pgbouncer.prod.test."
  security_groups = ["${split(",", var.security_groups)}"]
  user_data = "${data.template_file.dbproxy_20170323_ud.rendered}"

  lifecycle {
    create_before_destroy = true
  }
  root_block_device {
    volume_size = "100"
    volume_type = "gp2"
  }
}

resource "aws_launch_configuration" "dbproxy_lc" {
  image_id = "${var.ami}"
  associate_public_ip_address = "false"
  instance_type = "${var.instance_type}"
  security_groups = ["${split(",", var.security_groups)}"]
  enable_monitoring = "${var.enable_monitoring}"
  iam_instance_profile = "${var.instance_role}"

    lifecycle {
      create_before_destroy = true
    }

  user_data = <<END_OF_STRING
#cloud-config
manage_etc_hosts: false
preserve_hostname: true
bootcmd:
 - cloud-init-per instance my_set_hostname sh -xc "echo '${var.instance_name_prefix}-$INSTANCE_ID' | sed -e 's/-i-/-/g' > /etc/hostname; hostname -F /etc/hostname"
 - cloud-init-per instance my_etc_hosts sh -xc "sed -i -e '/^127.0.1.1/d' /etc/hosts; echo 127.0.1.1 $(cat /etc/hostname).${var.twitch_environment}.${var.aws_account}.us-west2.justin.tv $(cat /etc/hostname) >> /etc/hosts"
output: {all: '| tee -a /var/log/cloud-init-output.log'}
runcmd:
 - echo "clean=true" > /etc/facter/facts.d/clean.txt
 - echo "cluster=${var.cluster}" > /etc/facter/facts.d/cluster.txt
 - echo "pg_cluster=${var.cluster}.${var.pg_cluster}" > /etc/facter/facts.d/pg_cluster.txt
 - echo "twitch_environment=${var.twitch_environment}" > /etc/facter/facts.d/twitch_environment.txt
 - apt-get update
 - apt-get upgrade -y
 - puppet agent --test --server=puppet.internal.justin.tv
 - echo "$(date +'%F %T %Z') -- restarting host"
 - shutdown -r now
END_OF_STRING

  root_block_device {
    volume_size = "100"
    volume_type = "gp2"
  }
}
