resource "aws_launch_configuration" "dbproxy_lc" {
  image_id = "${var.ami}"
  associate_public_ip_address = "false"
  instance_type = "${var.instance_type}"
  security_groups = ["${split(",", var.security_groups)}"]
  enable_monitoring = "${var.enable_monitoring}"
  iam_instance_profile = "${var.instance_role}"

  lifecycle {
    create_before_destroy = true
  }

  user_data = <<END_OF_STRING
#cloud-config
manage_etc_hosts: false
preserve_hostname: true
bootcmd:
 - cloud-init-per instance my_set_hostname sh -xc "echo '${var.instance_name_prefix}-$INSTANCE_ID' | sed -e 's/-i-/-/g' > /etc/hostname; hostname -F /etc/hostname"
 - cloud-init-per instance my_etc_hosts sh -xc "sed -i -e '/^127.0.1.1/d' /etc/hosts; echo 127.0.1.1 $(cat /etc/hostname).${var.twitch_environment}.${var.aws_account}.us-west2.justin.tv $(cat /etc/hostname) >> /etc/hosts"
output: {all: '| tee -a /var/log/cloud-init-output.log'}
runcmd:
 - echo "clean=true" > /etc/facter/facts.d/clean.txt
 - echo "cluster=${var.cluster}" > /etc/facter/facts.d/cluster.txt
 - echo "disable_consul=true" > /etc/facter/facts.d/disable_consul.txt
 - echo "pg_cluster=${var.cluster}.${var.pg_cluster}" > /etc/facter/facts.d/pg_cluster.txt
 - echo "twitch_environment=${var.twitch_environment}" > /etc/facter/facts.d/twitch_environment.txt
 - locked=1
 - while [ $locked -ne 0 ]; do
 -   echo "$(date +'%F %T %Z') -- updating apt (30s sleep)"
 -   sleep 30
 -   apt-get update
 -   locked=$?
 - done
 - echo "$(date +'%F %T %Z') -- upgrading system"
 - export DEBIAN_FRONTEND=noninteractive
 - apt-get -y -o DPkg::Options::="--force-confold" upgrade
 - puppet agent --test --server=puppet.internal.justin.tv
 - echo "$(date +'%F %T %Z') -- restarting host"
 - shutdown -r now
END_OF_STRING

  root_block_device {
    volume_size = "100"
    volume_type = "gp2"
  }
}
