resource "aws_launch_configuration" "discovery_launch_conf_20160325" {
  image_id = "${var.ami}"
  associate_public_ip_address = "false"
  instance_type = "${var.instance_type}"
  security_groups = ["${split(",", var.security_groups)}"]
  enable_monitoring = "${var.enable_monitoring}"
  iam_instance_profile = "${var.instance_role}"


  lifecycle {
    create_before_destroy = true
  }


  user_data = <<END_OF_STRING
#cloud-config
preserve_hostname: true
manage_etc_hosts: false
bootcmd:
 - cloud-init-per instance my_set_hostname sh -xc "echo '${var.cluster}-$INSTANCE_ID' | sed -e 's/-i-/-/g' > /etc/hostname; hostname -F /etc/hostname"
 - cloud-init-per instance my_etc_hosts sh -xc "sed -i -e '/^127.0.1.1/d' /etc/hosts; echo 127.0.1.1 $(cat /etc/hostname).${var.twitch_environment}.${var.aws_account}.us-west2.justin.tv $(cat /etc/hostname) >> /etc/hosts"
runcmd:
 - echo "clean=true" > /etc/facter/facts.d/clean.txt
 - echo "cluster=${var.cluster}" > /etc/facter/facts.d/cluster.txt
 - echo "pg_cluster=${var.cluster}.${var.pg_cluster}" > /etc/facter/facts.d/pg_cluster.txt
 - echo "twitch_environment=${var.twitch_environment}" > /etc/facter/facts.d/twitch_environment.txt
 - apt-get update -y
 - apt-get upgrade -y
 - puppet agent --test --server=puppet.internal.justin.tv
 - echo "$(date +'%F %T %Z') -- starting data provisioning"
 - sudo -u postgres rm -rf /var/lib/postgresql/9.3/main
 - sudo -u postgres mkdir /var/lib/postgresql/9.3/main
 - sudo -u postgres chmod 0700 /var/lib/postgresql/9.3/main
 - sudo -u postgres /usr/lib/postgresql/9.3/bin/pg_basebackup -X stream -h "${var.upstream_master}" -D /var/lib/postgresql/9.3/main -U replication -c fast -R
 - echo "$(date +'%F %T %Z') -- database copied, finalizing puppet"
 - service postgres start
 - puppet agent --test
 - echo "$(date +'%F %T %Z') -- restarting host"
 - shutdown -r now
 - puppet agent --test --server=puppet.internal.justin.tv
END_OF_STRING

  root_block_device {
    volume_size = "${var.root_volume_size}"
    volume_type = "gp2"
  }
}
