data "aws_caller_identity" "current" {}

module "sitedb_export_via_glue" {
  source = "../../../../../stats/db-s3-glue"
  database_type = "postgresql"
  job_name = "${var.db_identifier}"

  cluster_name = "${var.db_identifier}"
  trigger_schedule = "0 15 * * ? *"
  # too many buckets in twitch-web-dev
  s3_output_bucket = "${rs}-${var.name}-${var.environment}-db-exports"
  create_s3_output_bucket = 0
  s3_output_bucket = "${var.s3_output_bucket}"
  s3_output_key = "glue/${var.db_identifier}/${var.environment}"
  create_s3_script_bucket = 0
  s3_script_bucket = "${var.s3_script_bucket}"
  error_sns_topic_name = "${aws_sns_topic.glue-errors.name}"
  account_number = "${data.aws_caller_identity.current.account_id}"
  vpc_id = "${var.vpc_id}"
  subnet_id = "${var.subnet_id}"
  availability_zone = "${var.aws_availability_zone}"
  yarn_memory_overhead_mb = 1024
  rds_subnet_group = "" # not used
  instance_iam_role_arn = "arn:aws:iam::${data.aws_caller_identity.current.account_id}:role/postgres" # XXX janky
  cluster_username = "${var.cluster_username}"
  db_password_parameter_name = "${aws_ssm_parameter.password.name}"
  db_password_key_id = "${aws_kms_alias.ssm.target_key_id}"
  api_key_parameter_name = "${aws_ssm_parameter.api_password.name}"
  api_key_kms_key_id = "${aws_kms_alias.api_ssm.target_key_id}"
  launch_template_id = "${aws_launch_template.sitedb_glue_export.id}"
  launch_template_version = "{$aws_launch_template.sitedb_glue_export.latest_version}"
  healthcheck_path = "/port/all"
  healthcheck_port = "6545"
  tahoe_producer_name = "sitedbexport"

  table_config = {
    "chat_notification_tokens" = <<EOF
{
  "dpu_count": 10,
  "version": 0,
  "schema": [
    {"name": "id", "type": "int" },
    {"name": "user_id", "type": "int" },
    {"name": "channel_id", "type": "int" },
    {"name": "kind", "type": "string" },
    {"name": "data", "type": "string" },
    {"name": "state", "type": "string" },
    {"name": "available_at", "type": "timestamp" },
    {"name": "created_at", "type": "timestamp" },
    {"name": "updated_at", "type": "timestamp" }
  ]
}
EOF
    "emoticon_images" = <<EOF
{
  "dpu_count": 5,
  "version": 0,
  "schema": [
    {"name": "id", "type": "int" },
    {"name": "emoticon_id", "type": "int" },
    {"name": "height", "type": "int" },
    {"name": "width", "type": "int" },
    {"name": "src", "type": "string" },
    {"name": "created_at", "type": "timestamp" },
    {"name": "updated_at", "type": "timestamp" }
  ]
}
EOF
    "emoticons" = <<EOF
{
  "dpu_count": 5,
  "version": 0,
  "schema": [
    {"name": "id", "type": "int" },
    {"name": "regex", "type": "string" },
    {"name": "image_name", "type": "string" },
    {"name": "height", "type": "int" },
    {"name": "width", "type": "int" },
    {"name": "state", "type": "string" },
    {"name": "created_on", "type": "timestamp" },
    {"name": "updated_on", "type": "timestamp" },
    {"name": "emoticon_set_id", "type": "int" },
    {"name": "regex_display", "type": "string" }
  ]
}
EOF
    "emoticon_sets" = <<EOF
{
  "dpu_count": 5,
  "version": 0,
  "schema": [
    {"name": "id", "type": "int" },
    {"name": "name", "type": "string" },
    {"name": "ticket_product_id", "type": "int" },
    {"name": "group_name", "type": "string" },
    {"name": "created_on", "type": "timestamp" },
    {"name": "updated_on", "type": "timestamp" },
    {"name": "prefix", "type": "string" },
    {"name": "prefix_state", "type": "string" }
  ]
}
EOF
    "ticket_product_revenue_configs" = <<EOF
{
  "dpu_count": 5,
  "version": 0,
  "schema": [
    {"name": "id", "type": "int" },
    {"name": "ticket_product_id", "type": "int" },
    {"name": "created_at", "type": "timestamp" },
    {"name": "updated_at", "type": "timestamp" }
  ]
}
EOF
    "ticket_products" = <<EOF
{
  "dpu_count": 10,
  "version": 0,
  "schema": [
    {"name": "id", "type": "int" },
    {"name": "ticket_type", "type": "string" },
    {"name": "is_template", "type": "boolean" },
    {"name": "name", "type": "string" },
    {"name": "ticket_product_owner_type", "type": "string" },
    {"name": "ticket_product_owner_id", "type": "int" },
    {"name": "availability_state", "type": "string" },
    {"name": "permissions", "type": "string" },
    {"name": "desc_invoice", "type": "string" },
    {"name": "desc_paywall", "type": "string" },
    {"name": "desc_checkout", "type": "string" },
    {"name": "features", "type": "string" },
    {"name": "default_price", "type": "int" },
    {"name": "prices", "type": "string" },
    {"name": "interval_unit", "type": "string" },
    {"name": "interval_number", "type": "int" },
    {"name": "rev_split_steps", "type": "string" },
    {"name": "updated_on", "type": "timestamp" },
    {"name": "created_on", "type": "timestamp" },
    {"name": "hidden", "type": "boolean" },
    {"name": "ext_product_id", "type": "string" },
    {"name": "short_name", "type": "string" },
    {"name": "hide_ads", "type": "boolean" },
    {"name": "ticket_access_start", "type": "timestamp" },
    {"name": "ticket_access_end", "type": "timestamp" },
    {"name": "rev_share", "type": "int" },
    {"name": "recurring", "type": "boolean" }
  ]
}
EOF
    "tickets" = <<EOF
{
  "dpu_count": 20,
  "version": 0,
  "schema": [
    {"name": "id", "type": "int" },
    {"name": "ticket_product_id", "type": "int" },
    {"name": "ticket_type", "type": "string" },
    {"name": "purchase_profile_id", "type": "int" },
    {"name": "owner_id", "type": "int" },
    {"name": "access_guid", "type": "string" },
    {"name": "access_start", "type": "timestamp" },
    {"name": "access_end", "type": "timestamp" },
    {"name": "renewable", "type": "boolean" },
    {"name": "set_to_renew", "type": "boolean" },
    {"name": "original_features", "type": "string" },
    {"name": "original_desc", "type": "string" },
    {"name": "notes", "type": "string" },
    {"name": "updated_on", "type": "timestamp" },
    {"name": "created_on", "type": "timestamp" },
    {"name": "origin_id", "type": "string" }
  ]
}
EOF
    "user_emoticons" = <<EOF
{
  "dpu_count": 5,
  "version": 0,
  "schema": [
    {"name": "id", "type": "int" },
    {"name": "user_id", "type": "int" },
    {"name": "emoticon_set_id", "type": "int" },
    {"name": "created_on", "type": "timestamp" },
    {"name": "updated_on", "type": "timestamp" }
  ]
}
EOF
  }

}

/*
test for puppet work.
We're using a full instance rather than the template because that feature is not currently available in terraform.
https://github.com/terraform-providers/terraform-provider-aws/issues/4264

resource "aws_security_group" "export_glue_sg" { // copies from glue module
  name = "${var.db_identifier}-glue-export-puppetp"
  description = "Allow DB export via Glue"
  vpc_id = "${var.vpc_id}"

  ingress {
    from_port = 0
    to_port   = 65535
    protocol  = "tcp"
    self      = true
  }

  ingress {
    from_port = 22
    to_port = 22
    protocol = "tcp"
    cidr_blocks = ["10.0.0.0/8"]
  }

  egress {
    from_port   = 0
    to_port     = 0
    protocol    = "-1"
    cidr_blocks = ["0.0.0.0/0"]
  }
}

resource "aws_instance" "export_glue_instance" {
  ami = "${var.ami}"
  associate_public_ip_address = "false"
  iam_instance_profile = "${var.iam_instance_profile}"
  instance_type = "i2.8xlarge"
  subnet_id = "${var.subnet_id}"
  user_data = "${data.template_file.sitedb_export_ud.rendered}"
  vpc_security_group_ids = ["${aws_security_group.export_glue_sg.id}"]

  ephemeral_block_device {
    device_name = "/dev/xvdf"
    virtual_name = "ephemeral0"
  }
  ephemeral_block_device {
     device_name = "/dev/xvdg"
     virtual_name = "ephemeral1"
  }
  ephemeral_block_device {
    device_name = "/dev/xvdh"
    virtual_name = "ephemeral2"
  }
  ephemeral_block_device {
    device_name = "/dev/xvdi"
    virtual_name = "ephemeral3"
  }
  ephemeral_block_device {
    device_name = "/dev/xvdj"
    virtual_name = "ephemeral4"
  }
  ephemeral_block_device {
    device_name = "/dev/xvdk"
    virtual_name = "ephemeral5"
  }
  ephemeral_block_device {
    device_name = "/dev/xvdl"
    virtual_name = "ephemeral6"
  }
  ephemeral_block_device {
    device_name = "/dev/xvdm"
    virtual_name = "ephemeral7"
  }
  root_block_device {
    volume_size = "500"
    volume_type = "gp2"
  }
  tags {
    Name = "sitedb-export-puppet"
    Owner = "abrashears@twicth.tv"
    Project = "sitedb-export"
  }
  timeouts {
    create = "1h"
    delete = "1h"
  }
}

output "private_ip" {
  value = "$aws_instance.export_glue_instance.private_ip}"
}
output "instance_id" {
  value = "$aws_instance.export_glue_instance.id}"
}
*/
