data "template_file" "sitedb_export_ud" {
  template="${file("${path.module}/sitedb_export.user_data")}"
  vars {
    account="${var.account}"
    branch="${var.puppet_branch}"
    cluster="${var.pg_cluster}"
    environment="${var.environment}"
    history="${var.pg_history}"
    version="${var.pg_version}"
  }
}

resource "aws_launch_template" "sitedb_glue_export" {
  name = "sitedb_glue_export"

  disable_api_termination = false
  ebs_optimized = false
  iam_instance_profile {
    name = "${var.iam_instance_profile}"
  }
  image_id = "${var.ami}"
  instance_initiated_shutdown_behavior = "terminate"
  instance_type = "i2.8xlarge"

  tag_specifications {
    resource_type = "instance"
    tags {
      Name = "sitedb-export-glue"
    }
  }

  # These block devices are referenced in the prepare-sitedb script
  block_device_mappings {
    device_name = "/dev/xvdf"
    virtual_name = "ephemeral0"
  }
  block_device_mappings {
    device_name = "/dev/xvdg"
    virtual_name = "ephemeral1"
  }
  block_device_mappings {
    device_name = "/dev/xvdh"
    virtual_name = "ephemeral2"
  }
  block_device_mappings {
    device_name = "/dev/xvdi"
    virtual_name = "ephemeral3"
  }
  block_device_mappings {
    device_name = "/dev/xvdj"
    virtual_name = "ephemeral4"
  }
  block_device_mappings {
    device_name = "/dev/xvdk"
    virtual_name = "ephemeral5"
  }
  block_device_mappings {
    device_name = "/dev/xvdl"
    virtual_name = "ephemeral6"
  }
  block_device_mappings {
    device_name = "/dev/xvdm"
    virtual_name = "ephemeral7"
  }
  block_device_mappings {
    device_name = "/dev/sda1"
    ebs {
      volume_size = "500"
      volume_type = "gp2"
    }
  }

  tags {
    Name = "sitedb-glue-export-launch-template"
    Owner = "abrashears@twitch.tv"
  }

  user_data = "${base64encode("${data.template_file.sitedb_export_ud.rendered}")}"
}
