resource "aws_sns_topic" "glue-errors" {
  name = "${var.team_code}-${var.name}-${var.environment}-glue-export-errors"
}

resource "aws_sns_topic_policy" "default" {
  arn = "${aws_sns_topic.glue-errors.arn}"
  policy = "${data.aws_iam_policy_document.glue-topic-policy.json}"
}

data "aws_iam_policy_document" "glue-topic-policy" {
  statement {
    actions = [
      "SNS:Publish",
    ]

    effect = "Allow"

    principals {
      type        = "Service"
      identifiers = ["events.amazonaws.com"]
    }

    resources = [
      "${aws_sns_topic.glue-errors.arn}",
    ]

    sid = "TrustCWEToPublishEventsToMyTopic"
  }
}
