resource "aws_kms_key" "a" {
  description = "${var.db_identifier} ${var.environment} backup credentials"
}

resource "aws_kms_alias" "ssm" {
  name = "alias/${var.db_identifier}/glue"
  target_key_id = "${aws_kms_key.a.key_id}"
}

resource "aws_ssm_parameter" "password" {
  name        = "/${var.environment}/database/${var.db_identifier}/password/backup"
  description = "${var.db_identifier}'s password for the backup role"
  type        = "SecureString"
  value       = "changeme"

  lifecycle {
    ignore_changes = [
      "value",
    ]
  }

  tags {
    environment = "${var.environment}"
    name        = "${var.name}"
    owner       = "${var.owner}"
    project     = "${var.project}"
    team        = "${var.team}"
  }
}

resource "aws_kms_key" "api" {
  description = "${var.db_identifier} ${var.environment} tahoe key"
}

resource "aws_kms_alias" "api_ssm" {
  name = "alias/${var.db_identifier}/tahoe"
  target_key_id = "${aws_kms_key.a.key_id}"
}

resource "aws_ssm_parameter" "api_password" {
  name        = "/${var.environment}/database/${var.db_identifier}/password/api"
  description = "${var.db_identifier}'s password for the taho api"
  type        = "SecureString"
  value       = "changeme"

  lifecycle {
    ignore_changes = [
      "value",
    ]
  }

  tags {
    environment = "${var.environment}"
    name        = "${var.name}"
    owner       = "${var.owner}"
    project     = "${var.project}"
    team        = "${var.team}"
  }
}
