variable "aws_profile" {
  type    = "string"
  default = "twitch-cb-aws"
}

variable "aws_region" {
  type    = "string"
  default = "us-west-2"
}

variable "aws_availability_zone" {
  type    = "string"
}

variable "ami" {
  type    = "string"
  default = "ami-07fc27dbdafc5c9d1"
}

variable "environment" {
  type        = "string"
  description = "Service environment."
  default     = "development"
}

variable "name" {
  type        = "string"
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)."
  default     = "sitedb"
}

variable "owner" {
  type        = "string"
  default     = "d8a@twitch.tv"
  description = "Team email alias."
}

variable "project" {
  type        = "string"
  default     = "d8a/provisioning"
  description = "GitHub repository name."
}

variable "account" {
  type        = "string"
  default     = "twitch-web-dev"
  description = "The account name where work will be performed."
}
variable "subnet_id" {
  type        = "string"
  description = "The subnet where work will be performed."
}
variable "vpc_id" {
  type        = "string"
  description = "The vpc where work will be performed."
}

variable "team" {
  type    = "string"
  default = "Rolling Stone"
}
variable "team_code" {
  type    = "string"
  default = "rs"
}
variable "db_identifier" {
  type        = "string"
  description = "The identifier for the DB to be used."
  default     = "justintv_dev"
}
variable "cluster_username" {
  type        = "string"
  description = "The role name in the database used to read the tables."
  default     = "backup"
}
variable "iam_instance_profile" {
  type        = "string"
  description = "The iam profile role for the instance."
  default     = "postgres"
}
variable "pg_cluster" {
  type        = "string"
  description = "Where to look for backup keys in consul."
  default     = "sitedb_95"
}
variable "pg_history" {
  type        = "string"
  description = "Location of the history files in s3."
  default     = "s3://d8a-web-backup/postgres/sitedb_production_95/wale/history/"
}
variable "pg_version" {
  type        = "string"
  description = "The postgresql version."
  default     = "9.5"
}
variable "puppet_branch" {
  type        = "string"
  description = "The puppet branch for configuration management."
  default     = "SiteDB"
}
variable "s3_script_bucket" {
  type        = "string"
  description = "Name of bucket to store the scripts for glue."
}
variable "s3_output_bucket" {
  type        = "string"
  description = "Name of the bucket to send the data. Consider using a bucket with an expiration policy."
}
