resource "aws_autoscaling_group" "asg_hotspare" {
    name = "hotspare_${var.cluster}_raid10_${var.twitch_environment}_${var.count}"
    launch_configuration = "${aws_launch_configuration.hot_spare_lc_20180302.name}"
    max_size = "${var.hot_spare_max_size}"
    min_size = "${var.hot_spare_min_size}"
    desired_capacity = "${var.hot_spare_desired_capacity}"

    vpc_zone_identifier = ["${split(",", var.subnet_id)}"]

    lifecycle {
      create_before_destroy = true
    }

    tag {
      key = "Environment"
      value = "${var.twitch_environment}"
      propagate_at_launch = true
    }
    tag {
      key = "Name"
      value = "${var.cluster}"
      propagate_at_launch = true
    }
    tag {
      key = "Owner"
      value = "${var.owner_tag}"
      propagate_at_launch = true
    }
    tag {
      key = "Project"
      value = "${var.project_tag}"
      propagate_at_launch = true
    }
    tag {
      key = "twitch_environment"
      value = "${var.twitch_environment}"
      propagate_at_launch = true
    }
}

output "hotspare_asg_name"{  
  value = "${aws_autoscaling_group.asg_hotspare.id}"
}
