resource "aws_autoscaling_group" "asg" {
    name = "${var.cluster}_raid10_${var.twitch_environment}_${var.count}"
    launch_configuration = "${aws_launch_configuration.read_replica_lc_20180823.name}"
    max_size = "${var.max_size}"
    min_size = "${var.min_size}"
    desired_capacity = "${var.desired_capacity}"
    load_balancers = ["${var.load_balancers}"]

    vpc_zone_identifier = ["${split(",", var.subnet_id)}"]

    lifecycle {
      create_before_destroy = true
    }

    tag {
      key = "Environment"
      value = "${var.twitch_environment}"
      propagate_at_launch = true
    }
    tag {
      key = "Name"
      value = "${var.cluster}"
      propagate_at_launch = true
    }
    tag {
      key = "Owner"
      value = "${var.owner_tag}"
      propagate_at_launch = true
    }
    tag {
      key = "Project"
      value = "${var.project_tag}"
      propagate_at_launch = true
    }
    tag {
      key = "twitch_environment"
      value = "${var.twitch_environment}"
      propagate_at_launch = true
    }
}

output "asg_name"{
  value = "${aws_autoscaling_group.asg.id}"
}
