##############################
#     Attached LC            #
##############################
data "template_file" "read_replica_ud_20180823" {
  template="${file("${path.module}/../templates.20170314/sitedb.20180823.user_data")}"
  vars {
    aws_account="${var.aws_account}"
    branch="${var.branch}"
    cluster="${var.cluster}"
    hostname_prefix="${var.instance_name_prefix}"
    pg_cluster="${var.pg_cluster}"
    pg_role="read-replica"
    twitch_environment="${var.twitch_environment}"
    upstream_master="${var.upstream_master}"
    version="${var.version}"
  }
}

resource "aws_launch_configuration" "read_replica_lc_20180823" {
  associate_public_ip_address = "false"
  enable_monitoring = "${var.enable_monitoring}"
  iam_instance_profile = "${var.instance_role}"
  image_id = "${var.image_id}"
  instance_type = "${var.instance_type}"
  name_prefix = "${var.instance_name_prefix}.prod.read-replica."
  security_groups = ["${split(",", var.security_groups)}"]
  user_data = "${data.template_file.read_replica_ud_20180823.rendered}"

  ephemeral_block_device {
    device_name = "/dev/xvdf"
    virtual_name = "ephemeral0"
  }
  ephemeral_block_device {
     device_name = "/dev/xvdg"
     virtual_name = "ephemeral1"
  }
  ephemeral_block_device {
    device_name = "/dev/xvdh"
    virtual_name = "ephemeral2"
  }
  ephemeral_block_device {
    device_name = "/dev/xvdi"
    virtual_name = "ephemeral3"
  }
  ephemeral_block_device {
    device_name = "/dev/xvdj"
    virtual_name = "ephemeral4"
  }
  ephemeral_block_device {
    device_name = "/dev/xvdk"
    virtual_name = "ephemeral5"
  }
  ephemeral_block_device {
    device_name = "/dev/xvdl"
    virtual_name = "ephemeral6"
  }
  ephemeral_block_device {
    device_name = "/dev/xvdm"
    virtual_name = "ephemeral7"
  }
  lifecycle {
    create_before_destroy = true
  }
  root_block_device {
    volume_size = "500"
    volume_type = "gp2"
  }
}
