resource "aws_autoscaling_group" "asg_science" {
    name = "science_${var.cluster}_${var.twitch_environment}_${var.count}"
    launch_configuration = "${aws_launch_configuration.science_lc_20180823.name}"
    max_size = "${var.science_max_size}"
    min_size = "${var.science_min_size}"
    desired_capacity = "${var.science_desired_capacity}"
    #NO ELB ATTACHED BECAUSE THIS IS SCIENCE

    vpc_zone_identifier = ["${split(",", var.subnet_id)}"]


    lifecycle {
      create_before_destroy = true
    }

    tag {
      key = "Environment"
      value = "${var.twitch_environment}"
      propagate_at_launch = true
    }
    tag {
      key = "Name"
      value = "${var.cluster}"
      propagate_at_launch = true
    }
    tag {
      key = "Owner"
      value = "${var.owner_tag}"
      propagate_at_launch = true
    }
    tag {
      key = "Project"
      value = "${var.project_tag}/science"
      propagate_at_launch = true
    }
    tag {
      key = "twitch_environment"
      value = "${var.twitch_environment}"
      propagate_at_launch = true
    }
}

output "science_asg_name"{
  value = "${aws_autoscaling_group.asg_science.id}"
}
