resource "aws_launch_configuration" "staging_conf_20160127" {
  image_id = "${var.ami}"
  associate_public_ip_address = "false"
  instance_type = "${var.instance_type}"
  security_groups = ["${split(",", var.security_groups)}"]
  enable_monitoring = "${var.enable_monitoring}"
  iam_instance_profile = "${var.instance_role}"
  ebs_block_device = {
      device_name = "/dev/xvdf"
      volume_type = "gp2"
      volume_size = "${var.ebs_size}"
    }

    lifecycle {
      create_before_destroy = true
    }


  user_data = <<END_OF_STRING
#cloud-config
manage_etc_hosts: false
preserve_hostname: true
bootcmd:
 - cloud-init-per instance my_set_hostname sh -xc "echo '${var.instance_name_prefix}-$INSTANCE_ID' | sed -e 's/-i-/-/g' > /etc/hostname; hostname -F /etc/hostname"
 - cloud-init-per instance my_etc_hosts sh -xc "sed -i -e '/^127.0.1.1/d' /etc/hosts; echo 127.0.1.1 $(cat /etc/hostname).${var.twitch_environment}.${var.aws_account}.us-west2.justin.tv $(cat /etc/hostname) >> /etc/hosts"
output: {all: '| tee -a /var/log/cloud-init-output.log'}
runcmd:
 - echo "clean=true" > /etc/facter/facts.d/clean.txt
 - echo "cluster=${var.cluster}" > /etc/facter/facts.d/cluster.txt
 - echo "pg_cluster=${var.cluster}.${var.pg_cluster}" > /etc/facter/facts.d/pg_cluster.txt
 - echo "twitch_environment=${var.twitch_environment}" > /etc/facter/facts.d/twitch_environment.txt
 - apt-get update
 - apt-get upgrade -y
 - apt-get install -y xfsprogs postgresql-common
 - mkfs.xfs -L postgres /dev/xvdf
 - mkdir /mnt/media
 - mount /dev/xvdf /mnt/media
 - mv /var/lib/postgresql /mnt/media
 - ln -s /mnt/media/postgresql /var/lib/postgresql
 - puppet agent --test --server=puppet.internal.justin.tv
 - echo "$(date +'%F %T %Z') -- restarting host"
 - shutdown -r now
END_OF_STRING

  root_block_device {
    volume_size = "500"
    volume_type = "gp2"
  }
}
