variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}

provider "aws" {
  access_key = "${var.twitch_aws_access_key}"
  region = "us-west-2"
  secret_key = "${var.twitch_aws_secret_key}"
}

variable "twitch_environment"{
  default = "development"
} 

###################################
#         ASG Config Vars         #
###################################
variable "min_size"{
  default = 0
}
variable "max_size"{
  default = 0
}
variable "desired_capacity"{
  default = 0
}
variable "cluster" {
  #default = "rails-postgres"
  description = "The puppet hiera cluster for configuration"
}
variable "owner_tag" {
  default = "d8a <d8a@justin.tv>"
  description = "Tag used on resource tags and names to help locate resources in AWS"
}
variable "project_tag" {
  default = "web/rails-postgres"
  description = "Tag used on resource tags and names to help locate resources in AWS"
}
variable "subnet_id" {
  #default = "subnet-b1af88d4,subnet-1d76336a,subnet-cbd54a92"
} 
variable "load_balancers"{
  description = "loadbalancer to attach to asg"
}
variable "count"{
  description = "which number asg is this?"
}

###################################
#         Launch Config Vars      #
###################################

variable "ami" {
  default = "ami-5e26c36d"
}
variable "aws_account"{
  description = "web-dev,web-aws"
}
variable "pg_cluster"{
  #default = "zookeeper"
  description = "Things like 'prod', 'replay', etc to uniquely identify the postgres cluster of master and replicas"
}
variable "instance_name_prefix" {
  #default = "rails-postgres-aws"
  description = "The dns name prefix to use -- usually the same as var.cluster"
}
variable "instance_type" {
  default = "i2.8xlarge"
}
variable "root_volume_size" {
  default = "250"
  description = "Root volume size in GB"
}
variable "security_groups" {
  description = "Comma separated list of security group ids"
  #default ="sg-3cd6a958"
}
variable "enable_monitoring"{
  description = "enable detailed monitoring"
}
variable "instance_role"{
    description = "instance role to launch instance with"
}
variable "ebs_size" {
  description = "size in GB"
}
