variable "twitch_dns_access_key" {}
variable "twitch_dns_secret_key" {}
provider "aws" {
  access_key = "${var.twitch_dns_access_key}"
  alias = "twitch_aws"  #this is twitch-aws account(science/r53 account) 2015-10-27
  region = "us-west-2"
  secret_key = "${var.twitch_dns_secret_key}"
}
variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}
provider "aws" {
  access_key = "${var.twitch_aws_access_key}"
  #alias = "twitch_aws" # XXX AGB: terraform fails if this is uncommented. 2015-10-02
  region = "us-west-2"
  secret_key = "${var.twitch_aws_secret_key}"
}

# XXX AGB: these should be coming from a remote resource. 2015-10-02
variable "data_a" {
  default = "subnet-650b9a12"
  description = "twitch_video_aws data_a"
}
variable "data_a_cidr" {
  default = "10.193.4.0/22"
}
variable "data_b" {
  default = "subnet-1e8bf87b"
  description = "twitch_video_aws data_b"
}
variable "data_b_cidr" {
  default = "10.193.0.0/22"
}
variable "data_c" {
  default = "subnet-287dc871"
  description = "twitch_video_aws data_c"
}
variable "data_c_cidr" {
  default = "10.193.8.0/22"
}
variable twitch_private_subnets {
  default = "10.0.0.0/8,127.0.0.1/32,192.168.0.0/16"
  #default = "10.0.0.0/8,192.16.64.0/21,199.9.248.0/21,185.42.204.0/22,127.0.0.1/32,38.99.10.97/32,192.168.0.0/16,45.113.128.0/22,103.53.48.0/22,192.108.239.0/24,23.160.0.0/24"
}
variable "vpc_cidr" {
  default = "10.193.0.0/18"
  description = "twitch_video_aws cidr"
}
variable "vpc_id" {
  default = "vpc-cae782af"
  description = "twitch_video_aws vpc id"
}

# consider making this a module
resource "aws_security_group" "db_sec" {
  description = "security rules for the staging aws discovery read replicas"
  name = "network_database_staging"
  vpc_id = "${var.vpc_id}"

  egress {
    from_port = 0
    to_port = 0
    protocol = -1
    cidr_blocks = ["0.0.0.0/0"]
  }
    ingress {
    from_port = 22
    to_port = 22
    protocol = "tcp"
    cidr_blocks = ["${split(",", var.twitch_private_subnets)}"]
  }
  ingress {
    from_port = 5432
    to_port = 5432
    protocol = "tcp"
    cidr_blocks = ["${var.vpc_cidr}"]
  }
  # There is not pii in network, so we err on the side of being open over secure from attackers.
  ingress {
    from_port = 5432
    to_port = 5432
    protocol = "tcp"
    cidr_blocks = ["${split(",", var.twitch_private_subnets)}"]
  }

  ingress {
    from_port = 6544
    to_port = 6544
    protocol = "tcp"
    cidr_blocks = ["${var.vpc_cidr}"]
  }
  # There is not pii in network, so we err on the side of being open over secure from attackers.
  ingress {
    from_port = 6544
    to_port = 6544
    protocol = "tcp"
    cidr_blocks = ["${split(",", var.twitch_private_subnets)}"]
  }

  tags {
    Name = "network-staging-postgres/security"
    Owner = "d8a <d8a@justin.tv>"
    Project = "video/network-staging-postgres"
  }
}

module "base" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/release/terraform.git//base?ref=terraform07"
}

variable "aws_account" {
  default = "twitch-video-aws"
}
variable "cluster" {
  default = "networkdb-staging"
  description = "The puppet hiera cluster for configuration"
}
variable "environment" {
  default = "staging"
  description = "The environment which will be used in naming and setting twitch_environment"
}

module "networkdb_00" {
  twitch_dns_access_key = "${var.twitch_dns_access_key}"
  twitch_dns_secret_key = "${var.twitch_dns_secret_key}"
  twitch_aws_access_key = "${var.twitch_aws_access_key}"
  twitch_aws_secret_key = "${var.twitch_aws_secret_key}"

  ami = "ami-dd11f3bd"
  associate_public_ip_address = "true"
  aws_account = "${var.aws_account}"
  cluster = "${var.cluster}"
  instance_name_prefix = "${var.cluster}"
  instance_role = "networkdb-postgres"
  instance_type = "c4.large"
  pg_cluster = "${var.environment}"
  project_tag = "video/network-staging"
  r53_zone_id = "${module.base.r53}"
  vpc_security_group_ids = "${aws_security_group.db_sec.id}"
  source = "../../../lib/simple.20150925"
  subnet_id = "${var.data_c}"
  twitch_environment = "${var.environment}"
}

module "networkdb_01" {
  twitch_dns_access_key = "${var.twitch_dns_access_key}"
  twitch_dns_secret_key = "${var.twitch_dns_secret_key}"
  twitch_aws_access_key = "${var.twitch_aws_access_key}"
  twitch_aws_secret_key = "${var.twitch_aws_secret_key}"

  ami = "ami-dd11f3bd"
  associate_public_ip_address = "true"
  aws_account = "${var.aws_account}"
  cluster = "${var.cluster}"
  instance_name_prefix = "${var.cluster}"
  instance_role = "networkdb-postgres"
  instance_type = "c4.large"
  pg_cluster = "${var.environment}"
  project_tag = "video/network-staging"
  r53_zone_id = "${module.base.r53}"
  vpc_security_group_ids = "${aws_security_group.db_sec.id}"
  source = "../../../lib/simple.20150925"
  subnet_id = "${var.data_c}"
  twitch_environment = "${var.environment}"
}
