variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}
provider "aws" {
  region = "us-west-2"
  access_key = "${var.twitch_aws_access_key}"
  secret_key = "${var.twitch_aws_secret_key}"
}

variable "twitch_dns_access_key" {}
variable "twitch_dns_secret_key" {}
provider "aws" {
  alias = "dns"
  region = "us-west-2"
  access_key = "${var.twitch_dns_access_key}"
  secret_key = "${var.twitch_dns_secret_key}"
}

module "base" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/release/terraform.git//base?ref=terraform07"
}

module "common" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/variables/twitch-web-aws/"
}
module "common_local" {
  source = "../../../modules/variables/twitch-web-aws/"
}
variable "topic_name" {
  default = "dbproxy_prod_topic"
}

variable "asg_name" {
  default = "dbproxy_prod_asg"
}

variable "lambda_arn" {
  default = "arn:aws:lambda:us-west-2:641044725657:function:asg_route53_update"
}

variable "aws_profile" {
  default = "postgres"
}

variable "twitch_environment"{
  default = "production"
}
variable "environment"{
  default = "prod"
}

variable "cluster_93" {
  default = "rails-pgbouncer"
  description = "The puppet hiera cluster for configuration"
}

variable "cluster_95" {
  default = "sitedb-pgbouncer"
  description = "The puppet hiera cluster for configuration"
}

variable "pg_cluster_93"{
  default = "rails-pgbouncer"
}

variable "pg_cluster_95"{
  default = "sitedb-pgbouncer"
}

variable "security_groups"{
  default = "sg-9c52bafb"
}

variable "instance_type"{
  default = "m4.xlarge"
}
variable "env"{
  default = "prod"
}
variable "instance_name_prefix_93"{
  default = "rails-pgbouncer"
}
variable "instance_name_prefix_95"{
  default = "sitedb-pgbouncer"
}
variable "aws_account" {
  default = "twitch-web-aws"
}
variable "enable_monitoring" {
  default = "true"
}
variable "instance_role"{
  default = "postgres"
}

variable "internal_zone_id" {
  default = "ZRG00SM48517Z"
  description = "us-west2.justin.tv"
}
variable "external_zone_id" {
  default = "ZL2XLO1TDFXZB"
  description = "us-west2.twitch.tv"
}
variable "owner" {
  default = "d8a@twitch.tv"
}
variable "pg_role" {
  description = "Role of the node in the cluster, eg 'hot-spare'"
  default = "dbproxy"
}
variable "dbproxy_topic_name"{
  default = "dbproxy_prod_topic"
}
variable "elb_name"{
  default = "rails-pgbouncer"
}

########################
#     Security Group   #
########################

module "d8a_prod_sg_00" {
  source = "../../../security_groups/lib/sg.20160122/"
  sg_environment = "${var.environment}"
  vpc_id = "${module.common.vpc_id}"
  vpc_cidr = "${module.common_local.vpc_cidr}"
  twitch_private_subnets = "${module.common_local.twitch_private_subnets}"
  data_a_cidr = "${module.common_local.data_a_cidr}"
  data_b_cidr = "${module.common_local.data_b_cidr}"
  data_c_cidr = "${module.common_local.data_c_cidr}"
  cluster = "${var.cluster_93}" # This can probably change after the upgrade

}

########################
#     DBProxy ELB      #
########################

resource "aws_security_group" "elb_sec" {
  description = "security rules for the production sitedb pgbouncer/master elb"
  name = "${var.cluster_93}_${var.environment}_elb" # This can probably change after the upgrade
  vpc_id = "${module.common.vpc_id}"

  egress {
    from_port = 0
    to_port = 0
    protocol = -1
    cidr_blocks = ["0.0.0.0/0"]
  }
  ingress {
    from_port = 12005
    to_port = 12005
    protocol = "tcp"
    cidr_blocks = ["${split(",", module.common_local.vpc_cidr)}",
      "10.193.192.0/21", "10.193.208.0/21", "10.193.224.0/21", "10.192.192.0/18", # mystery CIDRs
      "10.201.36.0/24", "10.201.37.0/24", "10.201.38.0/24", # payments-service
      "10.193.8.0/22", "10.193.4.0/22","10.193.0.0/22", # video (channel_properties)
      "10.202.52.0/22", # subs (twitch-hats-aws)
      "10.201.96.0/22", # subs (twitch-mako-prod)
      "10.201.228.0/22", # roster/permissions (twitch-cb-aws)
      "10.160.212.0/22", # users_service (us-east-1)
      "10.202.28.0/22", # users_service (us-west-2)
      "10.202.82.0/24", "10.202.81.0/24", "10.202.80.0/24", # subs (valhalla)
    ]
  }
  tags {
    Name = "sitedb-${var.environment}-postgres/security"
    Owner = "d8a <d8a@justin.tv>"
    Project = "web/sitedb-postgres"
  }
}

module "sitedb_replica_internal_elb"{
  source = "../../../elb/lib/lib.20160417.pgbouncer/"

  name = "${var.elb_name}"
  env = "${var.env}"
  subnets = "${module.common.data_a},${module.common.data_b},${module.common.data_c}"
  security_group = "${aws_security_group.elb_sec.id}"
  internal_zone_id = "${var.internal_zone_id}"
  external_zone_id = "${var.external_zone_id}"
  owner = "${var.owner}"
  pg_cluster = "${var.pg_cluster_93}"
  cluster = "${var.cluster_93}" # This can probably change after the upgrade
}

###########################################
#     DBProxy ASG For postgresql 9.5      #
###########################################

module "sitedb_pgbouncer_95"{
  ami = "ami-00411178"
  aws_account = "${var.aws_account}"
  source = "../../lib/dbproxy.20160204/"
  instance_type = "${var.instance_type}"
  security_groups = "${module.d8a_prod_sg_00.db_sec_id}"
  instance_name_prefix = "${var.instance_name_prefix_95}"
  enable_monitoring = "${var.enable_monitoring}"
  cluster = "${var.cluster_95}"
  twitch_environment = "${var.twitch_environment}"
  environment = "${var.environment}"
  max_size = "12"
  min_size = "0"
  desired_capacity = "0"
  subnet_id = "${module.common.data_a},${module.common.data_b},${module.common.data_c}"
  pg_cluster = "${var.pg_cluster_95}"
  instance_role = "${var.instance_role}"
  pg_role = "${var.pg_role}"
  project_tag = "${var.cluster_95}"
  load_balancers = "${module.sitedb_replica_internal_elb.internal_elb_pgbouncer_id}"
}

/*
module "notifications_sitedb_pgbouncer_95" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/asg-r53-lambda.git//modules/notifications"
  aws_profile = "web"
  topic_name = "${var.dbproxy_topic_name}"
  asg_name = "${module.sitedb_pgbouncer_95.asg_name}"
  lambda_arn = "${var.lambda_arn}"
}
*/
