variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}

provider "aws" {
  access_key = "${var.twitch_aws_access_key}"
  region = "us-west-2"
  secret_key = "${var.twitch_aws_secret_key}"
}

variable "twitch_dns_access_key" {}
variable "twitch_dns_secret_key" {}
provider "aws" {
  access_key = "${var.twitch_dns_access_key}"
  alias = "twitch_aws"  #this is twitch-aws account(science/r53 account) 2015-10-27
  region = "us-west-2"
  secret_key = "${var.twitch_dns_secret_key}"
}

module "base" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/release/terraform.git//base?ref=terraform07"
}

module "common" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/variables/twitch-web-aws/"
}
module "common_local" {
  source = "../../../modules/variables/twitch-web-aws/"
}
variable "topic_name" {
  default = "dbproxy_prod_topic"
}

variable "asg_name" {
  default = "dbproxy_prod_asg"
}

variable "lambda_arn" {
  default = "arn:aws:lambda:us-west-2:641044725657:function:asg_route53_update"
}

variable "aws_profile" {
  default = "postgres"
}

variable "twitch_environment"{
  default = "production"
} 
variable "environment"{
  default = "prod"
} 
variable "ami" {
  default = "ami-a66dccc6"
}

variable "cluster" {
  default = "canary-pgbouncer"
  description = "The puppet hiera cluster for configuration"
}

variable "pg_cluster"{
  default = "canary-pgbouncer"
}

variable "security_groups"{
  default = "sg-9c52bafb"
}

variable "instance_type"{
  default = "m4.xlarge"
}
variable "env"{
  default = "prod"
}
variable "instance_name_prefix"{
  default = "canary-pgbouncer"
}
variable "aws_account" {
  default = "twitch-web-aws"
}
variable "enable_monitoring" {
  default = "true"
}
variable "instance_role"{
  default = "postgres"
}

variable "internal_zone_id" {
  default = "ZRG00SM48517Z"
  description = "us-west2.justin.tv"
}
variable "external_zone_id" {
  default = "ZL2XLO1TDFXZB"
  description = "us-west2.twitch.tv"
}
variable "owner" {
  default = "d8a@twitch.tv"
}
variable "pg_role" {
  description = "Role of the node in the cluster, eg 'hot-spare'"
  default = "canary-dbproxy"
}
variable "dbproxy_topic_name"{
  default = "canary_dbproxy_prod_topic"
}

########################
#     Security Group   #
########################


module "d8a_prod_sg_00" {
  source = "../../../security_groups/lib/sg.20160122/"
  sg_environment = "${var.environment}"
  vpc_id = "${module.common.vpc_id}"
  vpc_cidr = "${module.common_local.vpc_cidr}"
  twitch_private_subnets = "${module.common_local.twitch_private_subnets}"
  data_a_cidr = "${module.common_local.data_a_cidr}"
  data_b_cidr = "${module.common_local.data_b_cidr}"
  data_c_cidr = "${module.common_local.data_c_cidr}"
  cluster = "${var.cluster}"

}

###############################
#     Canary DBProxy ASG      #
###############################


module "canary_dbproxy_prod_asg"{
  twitch_aws_access_key = "${var.twitch_aws_access_key}"
  twitch_aws_secret_key = "${var.twitch_aws_secret_key}"

  ami = "${var.ami}"
  aws_account = "${var.aws_account}"
  source = "../../lib/dbproxy.20170313/"
  instance_type = "${var.instance_type}"
  security_groups = "${module.d8a_prod_sg_00.db_sec_id}"
  instance_name_prefix = "${var.instance_name_prefix}"
  enable_monitoring = "${var.enable_monitoring}"
  cluster = "${var.cluster}"
  twitch_environment = "${var.twitch_environment}"
  environment = "${var.environment}"
  max_size = "0"
  min_size = "0"
  desired_capacity = "0"
  subnet_id = "${module.common.data_a},${module.common.data_b},${module.common.data_c}"
  pg_cluster = "${var.pg_cluster}"
  instance_role = "${var.instance_role}"
  pg_role = "${var.pg_role}"

}

module "notifications_dbproxy" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/asg-r53-lambda.git//modules/notifications"
  aws_profile = "web"
  topic_name = "${var.dbproxy_topic_name}"
  asg_name = "${module.canary_dbproxy_prod_asg.asg_name}"
  lambda_arn = "${var.lambda_arn}"
}

