variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}

provider "aws" {
  access_key = "${var.twitch_aws_access_key}"
  region = "us-west-2"
  secret_key = "${var.twitch_aws_secret_key}"
}

variable "twitch_dns_access_key" {}
variable "twitch_dns_secret_key" {}
provider "aws" {
  access_key = "${var.twitch_dns_access_key}"
  alias = "twitch_aws"  #this is twitch-aws account(science/r53 account) 2015-10-27
  region = "us-west-2"
  secret_key = "${var.twitch_dns_secret_key}"
}

module "base" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/release/terraform.git//base?ref=terraform07"
}

module "common" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/variables/twitch-web-aws/"
}
module "common_local" {
  source = "../../../modules/variables/twitch-web-aws/"
}

variable "topic_name" {
  default = "sitedb_raid_prod_topic"
}

variable "asg_name" {
  default = "sitedb_raid_prod_asg"
}

variable "lambda_arn" {
  default = "arn:aws:lambda:us-west-2:641044725657:function:asg_route53_update"
}

variable "aws_profile" {
  default = "postgres"
}

variable "environment"{
  default = "prod"
}

variable "twitch_environment"{
  default = "production"
}

variable "cluster_93" {
  default = "rails-postgres"
  description = "The puppet hiera cluster for configuration"
}

variable "cluster_95" {
  default = "sitedb-postgres"
  description = "The puppet hiera cluster for configuration"
}

variable "pg_cluster"{
  default = "sitedb"
}

variable "security_groups"{
  default = "sg-9c52bafb"
}

variable "instance_type"{
  default = "i2.8xlarge"
}
variable "env"{
  default = "prod"
}
variable "instance_name_prefix_93"{
  default = "rails-postgres"
}
variable "instance_name_prefix_95"{
  default = "sitedb-postgres"
}
variable "raid_topic_name" {
  default = "sitedb_raid_prod_topic"
}
variable "non_raid_topic_name" {
  default = "sitedb_non_raid_prod_topic"
}
variable "aws_account" {
  default = "twitch-web-aws"
}
variable "enable_monitoring" {
  default = "true"
}
variable "instance_role"{
  default = "postgres"
}
variable "elb_name"{
  default = "sitedb-replica"
}
variable "internal_zone_id" {
  default = "ZRG00SM48517Z"
  description = "us-west2.justin.tv"
}
variable "external_zone_id" {
  default = "ZL2XLO1TDFXZB"
  description = "us-west2.twitch.tv"
}
variable "owner" {
  default = "d8a@twitch.tv"
}
variable "sg_environment"{
  default = "prod"
}
variable "pg_role" {
  description = "Role of the node in the cluster, eg 'hot-spare'"
  default = "read-replica"
}

################################
#     Replica Security Group   #
################################

module "d8a_prod_sg_00" {
  source = "../../../security_groups/lib/sg.20160122/"
  sg_environment = "${var.sg_environment}"
  vpc_id = "${module.common.vpc_id}"
  vpc_cidr = "${module.common_local.vpc_cidr}"
  twitch_private_subnets = "${module.common_local.twitch_private_subnets}"
  data_a_cidr = "${module.common_local.data_a_cidr}"
  data_b_cidr = "${module.common_local.data_b_cidr}"
  data_c_cidr = "${module.common_local.data_c_cidr}"
  cluster = "sitedb_replica"

}


############################
#     ELB Security Group   #
############################

module "sitedb_replica_elb_sg" {
  twitch_aws_access_key = "${var.twitch_aws_access_key}"
  twitch_aws_secret_key = "${var.twitch_aws_secret_key}"

  source = "../../../security_groups/lib/sg.elb.sitedb.20160726/"

  # 10.193.192.0/21,10.193.208.0/21,10.193.224.0/21 : chat vpc cidrs (3)
  # 10.192.192.0/18 : passport vpc cidr
  # 10.193.8.0/22,10.193.4.0/22,10.193.0.0/22 : video cidrs (3)
  # 10.201.132.0/22 : twitch-sessions-aws vpc
  # 10.201.36.0/24,10.201.37.0/24,10.201.38.0/24 : revenue (3)
  # 10.202.52.0/22,10.201.96.0/22 : subs (hats, mako)
  # 10.201.228.0/22 : roster/permissions
  # 10.160.212.0/22,10.202.28.0/22 : users service (2: us-east1, us-west-2)
  # 10.202.82.0/24,10.202.81.0/24,10.202.80.0/24 : subs (valhalla)
  cidrs = "${module.common_local.service_a_cidr},${module.common_local.service_b_cidr},${module.common_local.service_c_cidr},10.193.192.0/21,10.193.208.0/21,10.193.224.0/21,10.192.192.0/18,10.193.8.0/22,10.193.4.0/22,10.193.0.0/22,10.201.132.0/22,10.201.36.0/24,10.201.37.0/24,10.201.38.0/24,10.202.52.0/22,10.201.96.0/22,10.201.228.0/22,10.160.212.0/22,10.202.28.0/22,10.202.82.0/24,10.202.81.0/24,10.202.80.0/24" # chat vpc cidrs (3), passport vpc cidr, video cidrs (3), twitch-sessions-aws vpc, revenue (3), subs (hats, mako), roster/permissions, users service (2: us-east1, us-west-2), subs (valhalla) (3)

  environment = "${var.environment}"
  sg_description = "security group for sg"
  sg_name = "sitedb-replica-elb-sg"
  sg_project = "sitedb-replica-sg"
  vpc_id = "${module.common.vpc_id}"

}


########################
#     Internal ELB     #
########################

module "sitedb_replica_internal_elb"{
  twitch_aws_access_key = "${var.twitch_aws_access_key}"
  twitch_aws_secret_key = "${var.twitch_aws_secret_key}"
  twitch_dns_access_key = "${var.twitch_dns_access_key}"
  twitch_dns_secret_key = "${var.twitch_dns_secret_key}"

  source = "../../../elb/lib/lib.20160425/"

  name = "${var.elb_name}"
  env = "${var.env}"
  subnets = "${module.common.data_a},${module.common.data_b},${module.common.data_c}"
  security_group = "${module.sitedb_replica_elb_sg.security_group_id}"
  internal_zone_id = "${var.internal_zone_id}"
  external_zone_id = "${var.external_zone_id}"
  owner = "${var.owner}"
  pg_cluster = "${var.pg_cluster}"
  cluster = "${var.cluster_93}"
}

#####################################
#      PG Sitedb ASG  2018-08-20    #
#####################################

module "sitedb_pg_raid_prod_asg_2018_08_20"{
  aws_account = "${var.aws_account}"
  source = "../../lib/sitedb-prod-asg-raid-20180823/"
  image_id = "ami-00411178"
  instance_type = "${var.instance_type}"
  security_groups = "${module.d8a_prod_sg_00.db_sec_id}"
  instance_name_prefix = "${var.instance_name_prefix_95}"
  enable_monitoring = "${var.enable_monitoring}"
  cluster = "${var.cluster_95}"
  twitch_environment = "${var.twitch_environment}"
  environment = "${var.environment}"
  project_tag = "${var.cluster_95}"
  version = "9.5"

  ##### IN ROTATION CAPACITY

  max_size = "6"
  min_size = "0"
  desired_capacity = "0"

  ###### SCIENCE CAPACITY

  science_max_size = "2"
  science_min_size = "0"
  science_desired_capacity = "0"

  subnet_id = "${module.common.data_a},${module.common.data_b},${module.common.data_c}"
  pg_cluster = "${var.pg_cluster}"
  instance_role = "${var.instance_role}"
  load_balancers = "${module.sitedb_replica_internal_elb.internal_elb_replica_id}"
  upstream_master = "sitedb-postgres-0bc8173deef12b574.production.twitch-web-aws.us-west2.justin.tv"
  pg_role = "${var.pg_role}"
  count = "2018_08_20"
}

module "notifications_raid_2018_08_20" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/asg-r53-lambda.git//modules/notifications"
  aws_profile = "web"
  topic_name = "${var.raid_topic_name}_2018_08_20"
  asg_name = "${module.sitedb_pg_raid_prod_asg_2018_08_20.asg_name}"
  lambda_arn = "${var.lambda_arn}"
}

module "notifications_science_2018_08_20" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/asg-r53-lambda.git//modules/notifications"
  aws_profile = "web"
  topic_name = "science_${var.raid_topic_name}_2018_08_20"
  asg_name = "${module.sitedb_pg_raid_prod_asg_2018_08_20.science_asg_name}"
  lambda_arn = "${var.lambda_arn}"
}
