module "sitedb-production-pagerduty" {
  env = "production"
  pagerduty_key = "${var.pagerduty_key}"
  pagerduty_service = "${var.pagerduty_service}"
  source = "../../../alarms/lib/pagerduty.20171103/"
}

module "sitedb-master-alarms" {
  elb_name = "${var.elb_name_master}"
  env = "${var.twitch_environment}"
  name = "rails-master"
  source = "../../../alarms/lib/sitedb.20171103/"
  threshold_connection = "${var.threshold_connection_master}"
  threshold_latency = "${var.threshold_latency}"
  topic_arn = "${module.sitedb-production-pagerduty.topic_arn}"
}

module "sitedb-replica-alarms" {
  elb_name = "${var.elb_name_replica}"
  env = "${var.twitch_environment}"
  name = "rails-replica"
  source = "../../../alarms/lib/sitedb.20171103/"
  threshold_connection = "${var.threshold_connection_replica}"
  threshold_latency = "${var.threshold_latency}"
  topic_arn = "${module.sitedb-production-pagerduty.topic_arn}"
}
