terraform {
  required_version = "0.11.13"
}

provider "aws" {
  profile = "twitch-web-aws"
  region = "us-west-2"
}

provider "aws" {
  alias = "dns"
  profile = "twitch-science-aws"
  region = "us-west-2"
}

variable "environment" {
  type        = "string"
  description = "Service environment"
  default     = "production"
}

module "common_local" {
  source = "../../../modules/variables/twitch-web-aws/"
}

module "sitedb_export" {
  source = "../../lib/sitedb-export.20181203"

  account = "twitch-web-aws"
  db_identifier = "justintv_prod"
  environment = "${var.environment}"
  subnet_id = "${module.common_local.data_a}"
  aws_availability_zone = "us-west-2a"
  #subnet_id = "${module.common_local.data_b}"
  #aws_availability_zone = "us-west-2b"
  vpc_id = "${module.common_local.vpc_id}"
  s3_script_bucket = "d8a-web-backup"
  s3_output_bucket = "twitch-d8a-web"
}


/*
test for puppet work.
We're using a full instance rather than the template because that feature is not currently available in terraform.
https://github.com/terraform-providers/terraform-provider-aws/issues/4264
*/

/*
module "base" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/release/terraform.git//base?ref=terraform07"
}

resource "aws_route53_record" "dns" {
  name = "sitedb-export-${replace(module.sitedb_export.instance_id, "i-", "")}.${var.environment}.twitch-web-aws.us-west2.justin.tv"
  provider = "aws.dns"
  records = ["${module.sitedb_export.private_ip}"]
  ttl = "300"
  type = "A"
  zone_id = "${module.base.r53}"
}
*/
