variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}
provider "aws" {
  #alias = "twitch_web_aws" # XXX AGB: terraform fails if this is uncommented. 2015-10-02
  region = "us-west-2"
  access_key = "${var.twitch_aws_access_key}"
  secret_key = "${var.twitch_aws_secret_key}"
}

variable "twitch_dns_access_key" {}
variable "twitch_dns_secret_key" {}
provider "aws" {
  alias = "dns"
  region = "us-west-2"
  access_key = "${var.twitch_dns_access_key}"
  secret_key = "${var.twitch_dns_secret_key}"
}

# XXX AGB: these should be coming from a remote resource. 2015-10-02
variable "data_a" {
  default = "subnet-57ffa932"
  description = "twitch_web_aws data_a"
}
variable "data_a_cidr" {
  default = "10.194.204.0/24"
}
variable "data_b" {
  default = "subnet-07f28670"
  description = "twitch_web_aws data_b"
}
variable "data_b_cidr" {
  default = "10.194.220.0/24"
}
variable "data_c" {
  default = "subnet-9dca43c4"
  description = "twitch_web_aws data_c"
}
variable "data_c_cidr" {
  default = "10.194.236.0/24"
}
variable twitch_private_subnets {
  default = "10.0.0.0/8,127.0.0.1/32,192.168.0.0/16,192.16.64.0/21"
  #default = "10.0.0.0/8,192.16.64.0/21,199.9.248.0/21,185.42.204.0/22,127.0.0.1/32,38.99.10.97/32,192.168.0.0/16,45.113.128.0/22,103.53.48.0/22,192.108.239.0/24,23.160.0.0/24"
}
variable "vpc_cidr" {
  default = "10.194.192.0/18"
  description = "twitch_web_aws cidr"
}
variable "twitch_vpn" {
  default = "10.255.244.0/22"
}
variable "barman_cidr"{
  default = "10.1.8.126/32"
}
variable "dms_cidr"{
  default = "10.202.28.0/22"
  description = "The cidr for aws data migration service instances used for users service"
}
variable "vpc_id" {
  default = "vpc-f44c0c91"
  description = "twitch_web_aws vpc id"
}

# consider making this a module
resource "aws_security_group" "db_sec" {
  description = "security rules for the production aws sitedb read replicas"
  name = "sitedb_replica_production"
  vpc_id = "${var.vpc_id}"

  egress {
    from_port = 0
    to_port = 0
    protocol = -1
    cidr_blocks = ["0.0.0.0/0"]
  }
  ingress {
    from_port = 22
    to_port = 22
    protocol = "tcp"
    cidr_blocks = ["${split(",", var.twitch_private_subnets)}", "${var.twitch_vpn}"]
  }
  ingress {
    from_port = 5432
    to_port = 5432
    protocol = "tcp"
    cidr_blocks = ["${var.data_a_cidr}", "${var.data_b_cidr}", "${var.data_c_cidr}", "${var.dms_cidr}", "${var.barman_cidr}" ]
  }
  ingress {
    from_port = 6542
    to_port = 6544
    protocol = "tcp"
    cidr_blocks = ["${split(",", var.vpc_cidr)}", "${split(",", var.twitch_private_subnets)}"]
  }
  ingress {
    # required for nagios monitoring
    from_port = 5666
    to_port = 5666
    protocol = "tcp"
    cidr_blocks = ["${split(",", var.twitch_private_subnets)}", "${var.twitch_vpn}"]
  }
  ingress {
    # for consul check
    from_port = 8306
    to_port = 8306
    protocol = "tcp"
    cidr_blocks = ["${split(",", var.twitch_private_subnets)}", "${var.twitch_vpn}"]
  }
  ingress {
    # for consul check
    from_port = 8306
    to_port = 8306
    protocol = "udp"
    cidr_blocks = ["${split(",", var.twitch_private_subnets)}", "${var.twitch_vpn}"]
  }
  tags {
    Name = "sitedb-postgres/security"
    Owner = "d8a <d8a@justin.tv>"
    Project = "web/sitedb-postgres"
  }
}

module "base" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/release/terraform.git//base?ref=terraform07"
}

variable "cluster_93" {
  default = "rails-postgres"
  description = "The puppet hiera cluster for configuration"
}
variable "cluster_95" {
  default = "sitedb-postgres"
  description = "The puppet hiera cluster for configuration"
}
variable "hostname_prefix" {
  default = "sitedb-postgres"
  description = "How the provisioned host should have their name prefixed"
}
variable "pg_cluster" {
  default = "sitedb"
  description = "Uniquely identify the postgres cluster of master and replicas"
}
variable "twitch_environment" {
  default = "production"
  description = "Used as the fact for development, production, and staging"
}

######################
## The new 9.5 cluster
######################

# 9.5 proposed master
module "sitedb_aws_master_2018_08_20" {
  ami = "ami-00411178"
  cluster = "${var.cluster_95}"
  hostname_prefix = "${var.hostname_prefix}"
  pg_cluster = "sitedb"
  pg_role = "region-master"
  pg_version = "9.5"
  r53_zone_id = "${module.base.r53}"
  vpc_security_group_ids = "${aws_security_group.db_sec.id}"
  source = "../../lib/sitedb.20180723"
  subnet_id = "${var.data_c}"
  twitch_environment = "production"
  puppet_environment = "SiteDB"
  upstream_master = ""
}

/*
# 9.5 hot spare
module "sitedb_aws_spare_2018_08_27" {
  ami = "ami-00411178"
  cluster = "${var.cluster_95}"
  hostname_prefix = "${var.hostname_prefix}"
  pg_cluster = "sitedb"
  pg_role = "spare"
  pg_version = "9.5"
  r53_zone_id = "${module.base.r53}"
  vpc_security_group_ids = "${aws_security_group.db_sec.id}"
  source = "../../lib/sitedb.20180723"
  subnet_id = "${var.data_b}"
  twitch_environment = "production"
  puppet_environment = "SiteDB"
  upstream_master = "${module.sitedb_aws_master_2018_08_20.fqdn}"
}
*/

/*
# corruption testing
module "sitedb_aws_wale_test_2018_10_22" {
  ami = "ami-00411178"
  cluster = "${var.cluster_95}"
  hostname_prefix = "${var.hostname_prefix}"
  instance_type = "i3.8xlarge"
  pg_cluster = "sitedb"
  pg_role = "wal-e-test"
  pg_version = "9.5"
  r53_zone_id = "${module.base.r53}"
  vpc_security_group_ids = "${aws_security_group.db_sec.id}"
  source = "../../lib/sitedb.20181022"
  subnet_id = "${var.data_a}"
  twitch_environment = "production"
  puppet_environment = "SiteDB"
  upstream_master = "${module.sitedb_aws_master_2018_08_20.fqdn}"
}
*/
