variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}

provider "aws" {
  access_key = "${var.twitch_aws_access_key}"
  region = "us-west-2"
  secret_key = "${var.twitch_aws_secret_key}"
}

variable "twitch_dns_access_key" {}
variable "twitch_dns_secret_key" {}
provider "aws" {
  access_key = "${var.twitch_dns_access_key}"
  alias = "twitch_aws"  #this is twitch-aws account(science/r53 account) 2015-10-27
  region = "us-west-2"
  secret_key = "${var.twitch_dns_secret_key}"
}

module "base" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/release/terraform.git//base?ref=terraform07"
}

module "common" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/variables/twitch-web-dev/"
}
module "common_local" {
  source = "../../../modules/variables/twitch-web-dev/"
}

variable "asg_name" {
  default = "discovery_postgres_dev_asg"
}

variable "lambda_arn" {
  default = "arn:aws:lambda:us-west-2:465369119046:function:asg_route53_update"
}

variable "twitch_environment"{
  default = "development"
}

variable "ami" {
  default = "ami-dd11f3bd"
}

variable "cluster" {
  default = "discovery-postgres-staging"
  description = "The puppet hiera cluster for configuration"
}

variable "pg_cluster"{
  default = "discovery-postgres-staging"
}

variable "subnet_id"{
  default = "subnet-b1af88d4,subnet-1d76336a,subnet-cbd54a92"
}

variable "security_groups"{
  default = "sg-7b5d2e1f"
}

variable "instance_type"{
  default = "m3.large"
}
variable "env"{
  default = "dev"
}

variable "aws_account" {
  default = "twitch-web-dev"
}

variable "enable_monitoring" {
  default = "true"
}
variable "instance_role"{
  default = "postgres_discovery_dev"
}
variable "elb_name"{
  default = "discovery-pg-replica"
}
variable "internal_zone_id" {
  default = "ZRG00SM48517Z"
  description = "us-west2.justin.tv"
}
variable "external_zone_id" {
  default = "ZL2XLO1TDFXZB"
  description = "us-west2.twitch.tv"
}
variable "owner" {
  default = "d8a@twitch.tv"
}
variable "sg_environment"{
  default = "dev"
}
variable "root_volume_size"{
  default = "250" # this was 2000 -- seemed overkill for staging?
}

variable "topic_name" {
  default = "discovery_dev_topic"
}

variable "service_cidr" {
  default = "10.194.0.0/21,10.194.16.0/21,10.194.32.0/21"
}

### we cant destory this because a instance not in this project ended up using this security group.

module "d8a_dev_sg_00" {
  source = "../../../security_groups/lib/sg.20160324/"
  sg_environment = "${var.sg_environment}-1"
  vpc_id = "${module.common.vpc_id}"
  vpc_cidr = "${module.common_local.vpc_cidr}"
  twitch_private_subnets = "${module.common_local.twitch_private_subnets}"
  data_cidr = "${module.common_local.data_a_cidr},${module.common_local.data_b_cidr},${module.common_local.data_c_cidr}"
  service_cidr = "${var.service_cidr}"
  sg_description = "discovery-postgres security group for postgres"
  sg_name = "discovery_postgres"
  sg_project = "web/discovery-staging"
}

