terraform {
  required_version = "0.11.8"
}

provider "aws" {
  profile = "twitch-web-dev"
  region = "us-west-2"
}

provider "aws" {
  alias = "dns"
  profile = "twitch-science-aws"
  region = "us-west-2"
}

variable "environment" {
  type        = "string"
  description = "Service environment"
  default     = "development"
}

module "common_local" {
  source = "../../../modules/variables/twitch-web-dev/"
}

module "sitedb_export" {
  source = "../../lib/sitedb-export.20181203"

  account = "twitch-web-dev"
  db_identifier = "justintv_dev"
  environment = "${var.environment}"
  subnet_id = "${module.common_local.data_b}"
  vpc_id = "${module.common_local.vpc_id}"
  s3_bucket = "data-eng-etl"
}

/*
test for puppet work.
We're using a full instance rather than the template because that feature is not currently available in terraform.
https://github.com/terraform-providers/terraform-provider-aws/issues/4264
*/

/*
module "base" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/release/terraform.git//base?ref=terraform07"
}

resource "aws_route53_record" "dns" {
  name = "sitedb-export-${replace(module.sitedb_export.instance_id, "i-", "")}.${var.environment}.twitch-web-dev.us-west2.justin.tv"
  provider = "aws.dns"
  records = ["${module.sitedb_export.private_ip}"]
  ttl = "300"
  type = "A"
  zone_id = "${module.base.r53}"
}
*/
