variable "aws_profile" {
  type    = "string"
  default = "twitch-cb-aws"
}

variable "aws_region" {
  type    = "string"
  default = "us-west-2"
}

variable "aws_availability_zone" {
  type    = "string"
  default = "us-west-2b"
}

variable "ami" {
  type    = "string"
  default = "ami-07fc27dbdafc5c9d1"
}

variable "environment" {
  type        = "string"
  description = "Service environment"
  default     = "development"
}

variable "name" {
  type        = "string"
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
  default     = "sitedb"
}

variable "owner" {
  type        = "string"
  default     = "d8a@twitch.tv"
  description = "Team email alias"
}

variable "project" {
  type        = "string"
  default     = "d8a/provisioning"
  description = "GitHub repository name"
}

variable "team" {
  type    = "string"
  default = "Rolling Stone"
}
variable "team_code" {
  type    = "string"
  default = "rs"
}
variable "db_identifier" {
  type        = "string"
  description = "The identifier for the DB to be used"
  default     = "justintv_prod"
}
variable "cluster_username" {
  type        = "string"
  description = "The role name in the database used to read the tables."
  default     = "backup"
}
variable "iam_instance_profile" {
  type        = "string"
  description = "The iam profile role for the instance"
  default     = "postgres"
}
variable "pg_cluster" {
  type        = "string"
  description = "Where to look for backup keys in consul"
  default     = "sitedb_95"
}
variable "pg_history" {
  type        = "string"
  description = "Location of the history files in s3"
  default     = "s3://d8a-web-backup/postgres/sitedb_production_95/wale/history/"
}
variable "pg_version" {
  type        = "string"
  description = "The postgresql version"
  default     = "9.5"
}
variable "puppet_branch" {
  type        = "string"
  description = "The puppet branch for configuration management"
  default     = "SiteDB"
}
