terraform {
  required_version = "0.11.13"
  backend "s3" {
    bucket = "twitch-web-dev"
    key = "tfstate/d8a/provisioning/pg/twitch-web-dev/sitedb-staging/terraform.tfstate"
    profile = "twitch-web-dev"
    region = "us-west-2"
  }
}

variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}
provider "aws" {
  #alias = "twitch_web_aws" # XXX AGB: terraform fails if this is uncommented. 2015-10-02
  region = "us-west-2"
  access_key = "${var.twitch_aws_access_key}"
  secret_key = "${var.twitch_aws_secret_key}"
}

variable "twitch_dns_access_key" {}
variable "twitch_dns_secret_key" {}
provider "aws" {
  alias = "dns"
  region = "us-west-2"
  access_key = "${var.twitch_dns_access_key}"
  secret_key = "${var.twitch_dns_secret_key}"
}

module "base" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/release/terraform.git//base?ref=terraform07"
}

variable "cluster" {
  default = "rails-postgres-staging"
  description = "The puppet hiera cluster for configuration"
}
variable "pg_cluster" {
  default = "sitedb"
  description = "Uniquely identify the postgres cluster of master and replicas"
}
variable "twitch_environment" {
  default = "staging"
  description = "Used as the fact for development, production, and staging"
}

variable "internal_zone_id" {
  default = "ZRG00SM48517Z"
  description = "us-west2.justin.tv"
}

variable "external_zone_id" {
  default = "ZL2XLO1TDFXZB"
  description = "us-west2.twitch.tv"
}

variable "pagerduty_key" {}
variable "pagerduty_service" {
  default = "P9BPZ4I"
  description = "The https://twitchoncall.pagerduty.com/services/XXXXXX service"
}


module "common" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/variables/twitch-web-dev/"
}
module "common_local" {
  source = "../../../modules/variables/twitch-web-dev/"
}

module "sitedb-staging-pagerduty" {
  pagerduty_key = "${var.pagerduty_key}"
  pagerduty_service = "${var.pagerduty_service}"
  source = "../../../alarms/lib/pagerduty.20171103/"
}

module "replica_sg" {
  source = "../../../security_groups/lib/sg.20160314/"
  sg_environment = "staging"
  vpc_id = "${module.common.vpc_id}"
  vpc_cidr = "${module.common_local.vpc_cidr}"
  #twitch_private_subnets = "${module.common_local.twitch_private_subnets}"
  twitch_private_subnets = "10.0.0.0/8,127.0.0.1/32,192.168.0.0/16,192.16.64.0/21"
  data_a_cidr = "${module.common_local.data_a_cidr}"
  data_b_cidr = "${module.common_local.data_b_cidr}"
  data_c_cidr = "${module.common_local.data_c_cidr}"
  cluster = "sitedb_staging"
  haproxy_port_low = "11005"
  haproxy_port_high = "11006"
}

resource "aws_route53_record" "master_cname" {
  provider = "aws.dns"
  zone_id = "${var.internal_zone_id}"
  name = "master-sitedb.staging"
  type = "CNAME"
  ttl = "60"
  records = ["${module.staging_master_95_b.fqdn}"]
}

resource "aws_route53_record" "replica_cname" {
  provider = "aws.dns"
  zone_id = "${var.internal_zone_id}"
  name = "replica-sitedb.staging"
  type = "CNAME"
  ttl = "60"

  // AGB: We're skipping the replica until we have time to implement
  // attaching a replica now that 9.5 promotes the master onto a new
  // timeline. This could hide bugs but for now we need something.
  records = ["${module.staging_master_95_b.fqdn}"]
}

##############
## 9.5 staging
##############

module "staging_master_95_a" {
  aws_account = "twitch-web-dev"

  instance_type = "i2.4xlarge"
  ami = "ami-00411178"
  pg_cluster = "sitedb"
  cluster = "sitedb-postgres-staging"
  hostname_prefix = "sitedb-postgres"
  pg_role = "staging-master-a"
  pg_version = "9.5"
  project_tag = "sitedb-postgres-staging"
  r53_zone_id = "${module.base.r53}"
  vpc_security_group_ids = "${module.replica_sg.db_sec_id}"
  source = "../../lib/sitedb-staging.20180828"
  subnet_id = "${module.common_local.data_b}"
  twitch_environment = "development"
  puppet_environment = "SiteDB"
  upstream_master = ""
}

/*
module "staging_replica_95_a" {
  aws_account = "twitch-web-dev"

  instance_type = "i2.4xlarge"
  ami = "ami-00411178"
  pg_cluster = "sitedb"
  cluster = "sitedb-postgres-staging"
  hostname_prefix = "sitedb-postgres"
  pg_role = "staging-replica-a"
  pg_version = "9.5"
  project_tag = "sitedb-postgres-staging"
  r53_zone_id = "${module.base.r53}"
  vpc_security_group_ids = "${module.replica_sg.db_sec_id}"
  source = "../../lib/sitedb-staging.20180828"
  subnet_id = "${module.common_local.data_c}"
  twitch_environment = "development"
  puppet_environment = "SiteDB"
  upstream_master = "${module.staging_master_95_a.fqdn}"
}
*/

module "staging_master_95_b" {
  aws_account = "twitch-web-dev"

  instance_type = "i2.4xlarge"
  ami = "ami-00411178"
  pg_cluster = "sitedb"
  cluster = "sitedb-postgres-staging"
  hostname_prefix = "sitedb-postgres"
  pg_role = "staging-master-b"
  pg_version = "9.5"
  project_tag = "sitedb-postgres-staging"
  r53_zone_id = "${module.base.r53}"
  vpc_security_group_ids = "${module.replica_sg.db_sec_id}"
  source = "../../lib/sitedb-staging.20180828"
  subnet_id = "${module.common_local.data_a}"
  twitch_environment = "development"
  puppet_environment = "SiteDB"
  upstream_master = ""
}

/*
module "staging_replica_95_b" {
  aws_account = "twitch-web-dev"

  instance_type = "i2.4xlarge"
  ami = "ami-00411178"
  pg_cluster = "sitedb"
  cluster = "sitedb-postgres-staging"
  hostname_prefix = "sitedb-postgres"
  pg_role = "staging-replica-b"
  pg_version = "9.5"
  project_tag = "sitedb-postgres-staging"
  r53_zone_id = "${module.base.r53}"
  vpc_security_group_ids = "${module.replica_sg.db_sec_id}"
  source = "../../lib/sitedb-staging.20180828"
  subnet_id = "${module.common_local.data_b}"
  twitch_environment = "development"
  puppet_environment = "SiteDB"
  upstream_master = "${module.staging_master_95_b.fqdn}"
}
*/

/*
module "pgexperts_sg" {
  source = "../../../security_groups/lib/sg.20160314/"
  sg_environment = "staging"
  vpc_id = "${module.common.vpc_id}"
  vpc_cidr = "${module.common_local.vpc_cidr}"
  twitch_private_subnets = "10.0.0.0/8,127.0.0.1/32,192.168.0.0/16,192.16.64.0/21"
  data_a_cidr = "${module.common_local.data_a_cidr}"
  data_b_cidr = "${module.common_local.data_b_cidr}"
  data_c_cidr = "${module.common_local.data_c_cidr}"
  cluster = "sitedb_analysis"
  haproxy_port_low = "12005"
  haproxy_port_high = "12006"
}


module "pgexperts_analysis_2018_09_17" {
  ami = "ami-00411178"
  aws_account = "twitch-web-dev"
  cluster = "sitedb-postgres"
  hostname_prefix = "pgexperts-postgres"
  pg_cluster = "sitedb"
  pg_role = "pgexperts analysis"
  pg_version = "9.5"
  r53_zone_id = "${module.base.r53}"
  vpc_security_group_ids = "${module.pgexperts_sg.db_sec_id}"
  source = "../../lib/sitedb.20180723"
  subnet_id = "${module.common_local.data_a}"
  twitch_environment = "development"
  puppet_environment = "SiteDB"
  upstream_master = "invalid.internal.justin.tv"
}
*/

/*
##
## Migration testing

module "slony_sg" {
  source = "../../../security_groups/lib/sg.20160314/"
  sg_environment = "staging"
  vpc_id = "${module.common.vpc_id}"
  vpc_cidr = "${module.common_local.vpc_cidr}"
  twitch_private_subnets = "10.0.0.0/8,127.0.0.1/32,192.168.0.0/16,192.16.64.0/21"
  data_a_cidr = "${module.common_local.data_a_cidr}"
  data_b_cidr = "${module.common_local.data_b_cidr}"
  data_c_cidr = "${module.common_local.data_c_cidr}"
  cluster = "sitedb_slony"
  haproxy_port_low = "12005"
  haproxy_port_high = "12006"
}

module "sitedb_slony_test_elb"{
  source = "../../../elb/lib/lib.20160417.pgbouncer/"

  name = "rails-pgbouncer-testing"
  env = "development"
  subnets = "${module.common.data_a},${module.common.data_b},${module.common.data_c}"
  security_group = "${module.slony_sg.db_sec_id}"
  internal_zone_id = "ZRG00SM48517Z"
  external_zone_id = "ZL2XLO1TDFXZB"
  owner = "d8a@twitch.tv"
  pg_cluster = "rails-postgres"
  cluster = "rails-postgres"
}

module "test_pgbouncer_93"{
  ami = "ami-00411178"
  aws_account = "twitch-web-dev"
  source = "../../lib/dbproxy.20160204/"
  instance_type = "m5.xlarge"
  security_groups = "${module.slony_sg.db_sec_id}"
  instance_name_prefix = "rails-pgbouncer"
  enable_monitoring = "false"
  cluster = "rails-pgbouncer"
  twitch_environment = "development"
  environment = "development"
  name_env = "dev"
  max_size = "2"
  min_size = "0"
  desired_capacity = "1"
  subnet_id = "${module.common.data_a},${module.common.data_b},${module.common.data_c}"
  pg_cluster = "rails-postgres"
  instance_role = "postgres"
  pg_role = "test"
  project_tag = "rails-postgres"
  load_balancers = "${module.sitedb_slony_test_elb.internal_elb_pgbouncer_id}"
}

module "test_pgbouncer_95"{
  ami = "ami-00411178"
  aws_account = "twitch-web-dev"
  source = "../../lib/dbproxy.20160204/"
  instance_type = "m5.xlarge"
  security_groups = "${module.slony_sg.db_sec_id}"
  instance_name_prefix = "sitedb-pgbouncer"
  enable_monitoring = "false"
  cluster = "sitedb-pgbouncer"
  twitch_environment = "development"
  environment = "development"
  name_env = "dev"
  max_size = "2"
  min_size = "0"
  desired_capacity = "1"
  subnet_id = "${module.common.data_a},${module.common.data_b},${module.common.data_c}"
  pg_cluster = "sitedb-postgres"
  instance_role = "postgres"
  pg_role = "test"
  project_tag = "sitedb-postgres"
  #load_balancers = "${module.sitedb_slony_test_elb.internal_elb_pgbouncer_id}"
}

module "sitedb_slony_source_2018_07_25" {
  ami = "ami-00411178"
  aws_account = "twitch-web-dev"
  cluster = "rails-postgres"
  pg_cluster = "sitedb"
  pg_role = "cloud_init_test"
  pg_version = "9.3"
  r53_zone_id = "${module.base.r53}"
  vpc_security_group_ids = "${module.slony_sg.db_sec_id}"
  source = "../../lib/sitedb.20180723"
  subnet_id = "${module.common_local.data_c}"
  twitch_environment = "development"
  puppet_environment = "SiteDB"
  upstream_master = ""
}

module "sitedb_slony_target_2018_07_25" {
  ami = "ami-00411178"
  aws_account = "twitch-web-dev"
  cluster = "sitedb-postgres"
  hostname_prefix = "sitedb-postgres"
  pg_cluster = "sitedb"
  pg_role = "cloud_init_test"
  pg_version = "9.5"
  r53_zone_id = "${module.base.r53}"
  vpc_security_group_ids = "${module.slony_sg.db_sec_id}"
  source = "../../lib/sitedb.20180723"
  subnet_id = "${module.common_local.data_a}"
  twitch_environment = "development"
  puppet_environment = "SiteDB"
  upstream_master = ""
}

module "sitedb_slony_replica_2018_07_25" {
  ami = "ami-00411178"
  aws_account = "twitch-web-dev"
  cluster = "sitedb-postgres"
  hostname_prefix = "sitedb-postgres"
  pg_cluster = "sitedb"
  pg_role = "cloud_init_test"
  pg_version = "9.5"
  r53_zone_id = "${module.base.r53}"
  vpc_security_group_ids = "${module.slony_sg.db_sec_id}"
  source = "../../lib/sitedb.20180723"
  subnet_id = "${module.common_local.data_b}"
  twitch_environment = "development"
  puppet_environment = "SiteDB"
  upstream_master = "${module.sitedb_slony_target_2018_07_25.fqdn}"
}
*/

/*
module "users_service_dms_sg" {
  source = "../../../security_groups/lib/sg.20160314/"
  sg_environment = "staging"
  vpc_id = "${module.common.vpc_id}"
  vpc_cidr = "${module.common_local.vpc_cidr}"
  twitch_private_subnets = "10.0.0.0/8,127.0.0.1/32,192.168.0.0/16,192.16.64.0/21"
  data_a_cidr = "${module.common_local.data_a_cidr}"
  data_b_cidr = "${module.common_local.data_b_cidr}"
  data_c_cidr = "${module.common_local.data_c_cidr}"
  cluster = "sitedb_slony"
  haproxy_port_low = "12005"
  haproxy_port_high = "12006"
}

module "users_service_dms_test_2018_09_21" {
  ami = "ami-00411178"
  aws_account = "twitch-web-dev"
  cluster = "sitedb-postgres"
  hostname_prefix = "sitedb-postgres"
  pg_cluster = "sitedb"
  pg_role = "dms_test"
  pg_version = "9.5"
  r53_zone_id = "${module.base.r53}"
  vpc_security_group_ids = "${module.users_service_dms_sg.db_sec_id}"
  source = "../../lib/sitedb.20180723"
  subnet_id = "${module.common_local.data_b}"
  twitch_environment = "development"
  puppet_environment = "SiteDB"
  upstream_master = "${module.staging_master_95_b.fqdn}"
}
*/
