resource "aws_instance" "instance" {
  ami = "${var.ami}"
  associate_public_ip_address = "false"
  instance_type = "${var.instance_type}"
  vpc_security_group_ids = ["${split(",", "${var.vpc_security_group_ids}")}"]
  subnet_id = "${var.subnet_id}"
  #iam_instance_profile = "${var.instance_role}"
  
  user_data = <<END_OF_STRING
#cloud-config
preserve_hostname: true
manage_etc_hosts: false
bootcmd:
 - cloud-init-per instance my_set_hostname sh -xc "echo '${var.cluster}-$INSTANCE_ID' | sed -e 's/-i-/-/g' > /etc/hostname; hostname -F /etc/hostname"
 - cloud-init-per instance my_etc_hosts sh -xc "sed -i -e '/^127.0.1.1/d' /etc/hosts; echo 127.0.1.1 $(cat /etc/hostname).${var.twitch_environment}.${var.aws_account}.us-west2.justin.tv $(cat /etc/hostname) >> /etc/hosts"
runcmd:
 - echo "cluster=${var.cluster}" > /etc/facter/facts.d/cluster.txt
 - echo "twitch_environment=${var.twitch_environment}" >> /etc/facter/facts.d/twitch_environment.txt
 - echo "clean=true" > /etc/facter/facts.d/clean.txt
 - puppet agent --test --server=puppet.internal.justin.tv
 - puppet agent --test
END_OF_STRING

  root_block_device {
    volume_size = "${var.root_volume_size}"
    volume_type = "gp2"
  }
  tags {
    Name = "${var.cluster}"
    Owner = "${var.owner_tag}"
    Project = "${var.project_tag}"
  }
}

resource "aws_route53_record" "dns" {
  name = "${var.cluster}-${replace(aws_instance.instance.id, "i-", "")}.${var.twitch_environment}.${var.aws_account}.us-west2.justin.tv"
  provider = "aws.twitch_dns"
  records = ["${aws_instance.instance.private_ip}"]
  ttl = "300"
  type = "A"
  zone_id = "${var.r53_zone_id}"
}

