data "template_file" "cluster_yaml" {
  template = "${file("${path.module}/templates/cluster.yaml.tmpl")}"

  vars {
    team = "${var.team}"
    sandstorm_role_arn = "${var.sandstorm_role_arn}"
    etl_bucket = "${var.etl_bucket}"
    role_arn = "${aws_iam_role.app.arn}"
    profile_arn = "${aws_iam_instance_profile.app.arn}"
  }
}

data "template_file" "env_yaml" {
  template = "${file("${path.module}/templates/env.yaml.tmpl")}"

  vars {
    team = "${var.team}"
    sandstorm_role_arn = "${var.sandstorm_role_arn}"
    etl_bucket = "${var.etl_bucket}"
    role_arn = "${aws_iam_role.app.arn}"
    profile_arn = "${aws_iam_instance_profile.app.arn}"
  }
}

resource "local_file" "cluster_yaml" {
    filename = "${path.cwd}/hiera/cluster/rds-buddy-${var.team}.yaml"
    content = "${data.template_file.cluster_yaml.rendered}"
}

resource "local_file" "environment_yaml" {
    filename = "${path.cwd}/hiera/environment/${var.twitch_environment}/rds-buddy-${var.team}.yaml"
    content = "${data.template_file.env_yaml.rendered}"
}
