resource "aws_iam_instance_profile" "app" {
    name = "iam_profile_rds_buddy_${var.team}_${var.twitch_environment}"
    roles = ["${aws_iam_role.app.name}"]
}

resource "aws_iam_role" "app" {
    name = "iam_role_rds_buddy_${var.team}_${var.twitch_environment}"
    assume_role_policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Action": "sts:AssumeRole",
            "Principal": {
                "Service": "ec2.amazonaws.com"
            },
            "Effect": "Allow",
            "Sid": ""
        }
    ]
}
EOF
}

resource "aws_iam_policy" "rds_modify_instance_policy" {
    name = "rds-buddy-${var.team}-modify-instance-policy"
    count = "${signum(var.has_instances)}"
    policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Action": "rds:ModifyDBInstance",
            "Effect": "Allow",
            "Resource": [
                ${var.managed_instance_arns}
            ]
        }
    ]
}
EOF
}

resource "aws_iam_policy_attachment" "rds_modify_instance_attach" {
    name = "rds-buddy-${var.team}-modify-instance-attach"
    count = "${signum(var.has_instances)}"
    roles = ["${aws_iam_role.app.name}"]
    policy_arn = "${aws_iam_policy.rds_modify_instance_policy.arn}"
}

resource "aws_iam_policy" "rds_modify_cluster_policy" {
    name = "rds-buddy-${var.team}-modify-cluster-policy"
    count = "${signum(var.has_clusters)}"
    policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Action": "rds:ModifyDBCluster",
            "Effect": "Allow",
            "Resource": [
                ${var.managed_cluster_arns}
            ]
        }
    ]
}
EOF
}

resource "aws_iam_policy_attachment" "rds_modify_cluster_attach" {
    name = "rds-buddy-${var.team}-modify-cluster-attach"
    count = "${signum(var.has_clusters)}"
    roles = ["${aws_iam_role.app.name}"]
    policy_arn = "${aws_iam_policy.rds_modify_cluster_policy.arn}"
}

resource "aws_iam_policy" "rds_buddy_policy" {
    name = "rds-buddy-${var.team}-access-policy"
    count = "${signum(var.raise_instance)}"
    policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Action": "sts:AssumeRole",
            "Resource": [
                "${var.sandstorm_role_arn}"
            ],
            "Effect": "Allow"
        }
    ]
}
EOF
}

resource "aws_iam_policy_attachment" "rds_buddy_attach" {
    name = "rds-buddy-${var.team}-access-attach"
    count = "${signum(var.raise_instance)}"
    roles = ["${aws_iam_role.app.name}"]
    policy_arn = "${aws_iam_policy.rds_buddy_policy.arn}"
}
