resource "aws_launch_configuration" "app" {
  image_id = "${var.ami_id}"
  associate_public_ip_address = "false"
  instance_type = "${var.service_instance_type}"
  security_groups = ["${split(",", "${var.security_groups}")}"]
  iam_instance_profile = "${aws_iam_instance_profile.app.id}"

  root_block_device {
    volume_size = 255
  }
	
  lifecycle {
    create_before_destroy = true
  }
  
  user_data = <<END_OF_STRING
#cloud-config
preserve_hostname: true
manage_etc_hosts: false
bootcmd:
 - cloud-init-per instance my_set_hostname sh -xc "echo "rds-buddy-${var.team}-${var.twitch_environment}-$INSTANCE_ID" | sed -e 's/-i-/-/g' > /etc/hostname; hostname -F /etc/hostname"
 - cloud-init-per instance my_etc_hosts sh -xc "sed -i -e '/^127.0.1.1/d' /etc/hosts; echo 127.0.1.1 $(cat /etc/hostname).${var.twitch_environment}.${var.aws_account}.us-west2.justin.tv $(cat /etc/hostname) >> /etc/hosts"
runcmd:
 - echo "cluster=rds-buddy-${var.team}" > /etc/facter/facts.d/cluster.txt
 - echo "twitch_environment=${var.twitch_environment}" >> /etc/facter/facts.d/twitch_environment.txt
 - echo "clean=true" > /etc/facter/facts.d/clean.txt
 - puppet agent --test --server=puppet.internal.justin.tv
 - puppet agent --test
END_OF_STRING
}
