variable "aws_access_key" {}
variable "aws_secret_key" {}

variable "subnet_id" {}
variable "security_groups" {}
variable "team" {}

variable "twitch_environment" {
    default = "development"
}

variable "aws_region" {
    default = "us-west-2"
}

provider "aws" {
    region = "${var.aws_region}"
    access_key = "${var.aws_access_key}"
    secret_key = "${var.aws_secret_key}"
}

variable "aws_account" {}

variable "ami_id" {
    default = "ami-a84bfbc8"
}

variable "service_instance_type" {
    default = "t2.small"
}

variable "owner_tag" {
  default = "d8a <d8a@justin.tv>"
  description = "Tag used on resource tags and names to help locate resources in AWS"
}
variable "project_tag" {
  default = "d8a/rds-buddy"
  description = "Tag used on resource tags and names to help locate resources in AWS"
}

variable "raise_instance" {
    default = 0
}

variable "sandstorm_role_arn" {
    default = ""
}

variable "has_instances" {
    default = 0
}
variable "managed_instance_arns" {
    default = ""
}

variable "has_clusters" {
    default = 0
}
variable "managed_cluster_arns" {
    default = ""
}
