provider "pagerduty" {
    token = "${var.pagerduty_key}"
}

data "pagerduty_vendor" "cloudwatch" {
  name = "Amazon CloudWatch"
}

resource "pagerduty_service_integration" "cloudwatch_alarms" {
    name = "${var.team} RDS Buddy Cloudwatch Integration (${var.twitch_environment})"
    service = "${var.pagerduty_service}"
    vendor  = "${data.pagerduty_vendor.cloudwatch.id}"
}

resource "aws_sns_topic" "cloudwatch_alarms" {
    name = "rds-buddy-${var.team}-${var.twitch_environment}-cloudwatch-alarms"
}

resource "aws_sns_topic_subscription" "alarms_subscription" {
    topic_arn = "${aws_sns_topic.cloudwatch_alarms.arn}"
    endpoint_auto_confirms = true
    protocol = "https"
    endpoint = "https://events.pagerduty.com/integration/${pagerduty_service_integration.cloudwatch_alarms.integration_key}/enqueue"
}
