resource "aws_s3_bucket" "etl-bucket" {
  bucket = "${var.etl_bucket}"
  acl    = "private"

  tags {
    Name        = "bucket to hold state and temp files for zenyatta"
    Environment = "${var.twitch_environment}"
  }

  lifecycle_rule {
  	id 	= "spark-logs"
  	enabled = true

  	prefix  = "${var.spark_log_prefix}"
  	expiration {
      days = 7
    }
  }
}
