variable "pagerduty_key" {}
variable "pagerduty_service" {}

variable "subnet_id" {}
variable "security_groups" {}
variable "team" {}
variable "etl_bucket" {}

variable "twitch_environment" {
    default = "development"
}

variable "aws_region" {
    default = "us-west-2"
}

provider "aws" {
    alias = "${var.aws_account}"
    region = "${var.aws_region}"
    profile = "${var.aws_profile}"
}

variable "aws_account" {}
variable "science_aws_account_number" {
  default = "673385534282"
}
variable "aws_profile" {}

variable "ami_id" {
    default = "ami-fb41ca9b"
}

variable "service_instance_type" {
    default = "m4.large"
}

variable "owner_tag" {
  default = "d8a <d8a@justin.tv>"
  description = "Tag used on resource tags and names to help locate resources in AWS"
}
variable "project_tag" {
  default = "d8a/rds-buddy"
  description = "Tag used on resource tags and names to help locate resources in AWS"
}

variable "raise_instance" {
    default = 0
}

variable "sandstorm_role_arn" {
    default = ""
}

# Utility vars
# For use with creating FQDNs
variable "env_shortname" {
  type = "map"
  default = {
    production = "prod"
    staging = "staging"
    development = "dev"
  }
}

variable "spark_log_prefix" {
  default = "zenyatta/spark/scripts/"
  description = "s3 objects to clean up after 7 days"
}
