resource "aws_sns_topic" "zenyatta_finished" {
  name = "zenyatta-finished"
}

data "aws_iam_policy_document" "sns-allow_publish_from_everyone" {
  count="${signum(length(var.sns_auth_accounts))}"
  statement {
    sid = "1"
    principals {
      type        = "AWS"
      identifiers = "${var.sns_auth_accounts}"
    }
    actions = ["sns:Publish"]
    resources = ["${aws_sns_topic.zenyatta_finished.arn}"]
  }
}

# instantiate the topic policy
resource "aws_sns_topic_policy" "notifications-stream_event-sns" {
  count="${signum(length(var.sns_auth_accounts))}"
  arn = "${aws_sns_topic.zenyatta_finished.arn}"
  policy = "${data.aws_iam_policy_document.sns-allow_publish_from_everyone.json}"
}
