variable "pagerduty_key" {}

variable "etl_bucket" {
    default = "twitch-piper-zenyatta-dev"
}

module "rds_buddy" {
    source = "../lib/rds-buddy.20170919/"

    subnet_id = "subnet-518f0b0a,subnet-bf46abd9,subnet-1380875a"
    security_groups = "sg-804df7fa"

    team = "data-eng"
    twitch_environment = "staging"
    aws_account = "twitch-service-piper-dev"
    aws_profile = "twitch-service-piper-dev"
    
    etl_bucket = "${var.etl_bucket}"

    pagerduty_key = "${var.pagerduty_key}"
    pagerduty_service = "P9BPZ4I"

    owner_tag = "d8a@justin.tv"
    project_tag = "d8a/rds-buddy"

    raise_instance = 1
    sandstorm_role_arn = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/rds_sandstorm_data-eng_staging"
}

provider "aws" {
    region = "us-west-2"
    profile = "twitch-service-piper-dev"
}
