variable "aws_access_key" {}
variable "aws_secret_key" {}
variable "pagerduty_key" {}

variable "environment" {
    default = "production"
}

variable "team" {
    default = "data-eng"
}

variable "aws_account" {
    default = "twitch-web-aws"
}

module "common" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/variables/twitch-web-aws"
}

module "asg" {
    source = "../lib/rds-buddy.20170919/"

    subnet_id = "${module.common.service_a},${module.common.service_b},${module.common.service_c}"
    security_groups = "${module.common.twitch_subnets}"
    team = "${var.team}"
    twitch_environment = "${var.environment}"
    aws_account = "${var.aws_account}"
    aws_profile = "${var.aws_account}"
    etl_bucket = "twitch-d8a"

    pagerduty_key = "${var.pagerduty_key}"
    pagerduty_service = "P7OL26Q"

    raise_instance = 1
    sandstorm_role_arn = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/rds_sandstorm_data-eng_production"

}

module "zenyatta-sns" {
    source = "../lib/zenyatta-sns.20171116"

    sns_auth_accounts = [
      "arn:aws:iam::316550374861:root",
      "arn:aws:iam::433397531694:root",
      "arn:aws:iam::924637445623:root",
    ]
}

variable "owner_tag" {
  default = "d8a <d8a@justin.tv>"
  description = "Tag used on resource tags and names to help locate resources in AWS"
}
variable "project_tag" {
  default = "d8a/rds-buddy"
  description = "Tag used on resource tags and names to help locate resources in AWS"
}

provider "aws" {
    region = "us-west-2"
    profile = "${var.aws_account}"
}

module "notifications_route53" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/asg-r53-lambda.git//modules/notifications"
  aws_profile = "web"
  topic_name = "rds-buddy_r53_${var.team}_${var.environment}"
  asg_name = "${module.asg.asg_name}"
  lambda_arn = "arn:aws:lambda:us-west-2:641044725657:function:asg_route53_update"
}
