variable "pagerduty_key" {}

variable "environment" {
    default = "staging"
}

variable "team" {
    default = "data-eng"
}

variable "aws_account" {
    default = "twitch-web-dev"
}

variable "etl_bucket" {
    default = "data-eng-etl"
}

module "common" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/variables/twitch-web-dev"
}

module "asg" {
    source = "../lib/rds-buddy.20170919/"

    subnet_id = "${module.common.service_a},${module.common.service_b},${module.common.service_c}"
    security_groups = "${module.common.twitch_subnets}"
    team = "${var.team}"
    twitch_environment = "${var.environment}"
    aws_account = "${var.aws_account}"
    aws_profile = "${var.aws_account}"
    etl_bucket = "${var.etl_bucket}"

    pagerduty_key = "${var.pagerduty_key}"
    pagerduty_service = "P7OL26Q"

    raise_instance = 2
    sandstorm_role_arn = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/rds_sandstorm_data-eng_staging"
}

module "zenyatta-sns" {
    source = "../lib/zenyatta-sns.20171116"

    sns_auth_accounts = [
    ]
}

provider "aws" {
    region = "us-west-2"
    profile = "${var.aws_account}"
}

module "notifications_route53" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/asg-r53-lambda.git//modules/notifications"
  aws_profile = "web"
  topic_name = "rds-buddy_r53_${var.team}_${var.environment}"
  asg_name = "${module.asg.asg_name}"
  lambda_arn = "arn:aws:lambda:us-west-2:465369119046:function:asg_route53_update"
}
