variable "twitch_dns_access_key" {}
variable "twitch_dns_secret_key" {}
provider "aws" {
  access_key = "${var.twitch_dns_access_key}"
  alias = "twitch_dns"
  region = "us-west-2"
  secret_key = "${var.twitch_dns_secret_key}"
}

variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}
provider "aws" {
  access_key = "${var.twitch_aws_access_key}"
  #alias = "twitch_web_aws" # XXX AGB: terraform fails if this is uncommented. 2015-10-02
  region = "us-west-2"
  secret_key = "${var.twitch_aws_secret_key}"
}

variable "allocated_storage"{}
variable "apply_immediately"{}
variable "aws_account"{}
variable "backup_retention_period"{}
variable "backup_window"{}
variable "dbname"{}
variable "engine"{}
variable "engine_version"{}
variable "environment"{}
variable "identifier"{}
variable "instance_class"{}
variable "internal_zone_id"{}
variable "maintenance_window"{}
variable "password"{}
variable "publicly_accessible"{}
variable "storage_type"{}
variable "username"{}
variable "vpc_security_group_ids" {}

variable "parameter_group_name"{}
####################################
#    Master Specific Variables     #
####################################

variable "db_subnet_group_name"{}
variable "multi_az"{}

resource "aws_db_instance" "rds-instance-master" {

  allocated_storage    = "${var.allocated_storage}"
  engine               = "${var.engine}"
  engine_version       = "${var.engine_version}"
  instance_class       = "${var.instance_class}"
  name                 = "${var.dbname}"
  identifier           = "${var.identifier}"
  username             = "${var.username}"
  password             = "${var.password}"
  db_subnet_group_name  = "${var.db_subnet_group_name}"
  parameter_group_name = "${var.parameter_group_name}"
  storage_type         = "${var.storage_type}"
  multi_az             = "${var.multi_az}"
  publicly_accessible  = "${var.publicly_accessible}"
  backup_retention_period = "${var.backup_retention_period}"
  vpc_security_group_ids = ["${var.vpc_security_group_ids}"]
  backup_window         = "${var.backup_window}"
  maintenance_window    = "${var.maintenance_window}"
  apply_immediately    = "${var.apply_immediately}"
}

resource "aws_route53_record" "cname" {
  provider = "aws.twitch_dns"
  zone_id = "${var.internal_zone_id}"
  name = "${var.identifier}.${var.environment}.${var.aws_account}"
  type = "CNAME"
  ttl = "60"
  records = ["${aws_db_instance.rds-instance-master.address}"]
}

output "id"{
  value = "${aws_db_instance.rds-instance-master.id}"
}

output "cname"{
  value = "${aws_route53_record.cname.fqdn}"
}
