variable "twitch_dns_access_key" {}
variable "twitch_dns_secret_key" {}
provider "aws" {
  access_key = "${var.twitch_dns_access_key}"
  alias = "twitch_dns"
  region = "us-west-2"
  secret_key = "${var.twitch_dns_secret_key}"
}

variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}
provider "aws" {
  access_key = "${var.twitch_aws_access_key}"
  #alias = "twitch_web_aws" # XXX AGB: terraform fails if this is uncommented. 2015-10-02
  region = "us-west-2"
  secret_key = "${var.twitch_aws_secret_key}"
}

variable "allocated_storage"{}
variable "apply_immediately"{}
variable "aws_account"{}
variable "dbname"{}
variable "engine"{}
variable "engine_version"{}
variable "environment"{}
variable "identifier"{}
variable "instance_class"{}
variable "internal_zone_id"{}
variable "maintenance_window"{}
variable "password"{}
variable "publicly_accessible"{}
variable "storage_type"{}
variable "username"{}
variable "vpc_security_group_ids" {}

variable "parameter_group_name"{}
#####################################
#     Replica Specific Variables    #
#####################################
variable "replicate_source_db"{}


resource "aws_db_instance" "rds-instance-replica" {
  allocated_storage    = "${var.allocated_storage}"
  engine               = "${var.engine}"
  engine_version       = "${var.engine_version}"
  instance_class       = "${var.instance_class}"
  name                 = "${var.dbname}"
  identifier           = "${var.identifier}"
  username             = "${var.username}"
  password             = "${var.password}"
  parameter_group_name = "${var.parameter_group_name}"
  storage_type         = "${var.storage_type}"
  publicly_accessible  = "${var.publicly_accessible}"
  replicate_source_db  = "${var.replicate_source_db}"
  vpc_security_group_ids = ["${var.vpc_security_group_ids}"]
  maintenance_window   = "${var.maintenance_window}"
  apply_immediately    = "${var.apply_immediately}"
}

resource "aws_route53_record" "cname" {
  provider = "aws.twitch_dns"
  zone_id = "${var.internal_zone_id}"
  name = "${var.identifier}.${var.environment}.${var.aws_account}"
  type = "CNAME"
  ttl = "60"
  records = ["${aws_db_instance.rds-instance-replica.address}"]
}

output "id"{
  value = "${aws_db_instance.rds-instance-replica.id}"
}

output "cname"{
  value = "${aws_route53_record.cname.fqdn}"
}
