variable "twitch_dns_access_key" {}
variable "twitch_dns_secret_key" {}
provider "aws" {
  access_key = "${var.twitch_dns_access_key}"
  alias = "twitch_dns"
  region = "us-west-2"
  secret_key = "${var.twitch_dns_secret_key}"
}

variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}
provider "aws" {
  access_key = "${var.twitch_aws_access_key}"
  #alias = "twitch_web_aws" # XXX AGB: terraform fails if this is uncommented. 2015-10-02
  region = "us-west-2"
  secret_key = "${var.twitch_aws_secret_key}"
}


variable "allocated_storage"{}
variable "dbname"{}
variable "engine"{}
variable "engine_version"{}
variable "environment"{}
variable "identifier"{}
variable "instance_class"{}
variable "internal_zone_id"{}
variable "password"{}
variable "parameter_group_name"{}
variable "publicly_accessible"{}
variable "replicate_source_db"{}
variable "storage_type"{}
variable "username"{}
variable "vpc_security_group_ids" {}

resource "aws_db_instance" "rds-instance" {
  allocated_storage    = "${var.allocated_storage}"
  engine               = "${var.engine}"
  engine_version       = "${var.engine_version}"
  instance_class       = "${var.instance_class}"
  name                 = "${var.dbname}"
  identifier           = "${var.identifier}"
  username             = "${var.username}"
  password             = "${var.password}"
#  db_subnet_group_name = "${var.db_subnet_group_name}"
#  parameter_group_name = "${var.parameter_group_name}"
  storage_type         = "${var.storage_type}"
  publicly_accessible  = "${var.publicly_accessible}"
  replicate_source_db  = "${var.replicate_source_db}"
  vpc_security_group_ids = ["${var.vpc_security_group_ids}"]
}

resource "aws_route53_record" "cname" {
  provider = "aws.twitch_dns"
  zone_id = "${var.internal_zone_id}"
  name = "${var.identifier}.${var.environment}"
  type = "CNAME"
  ttl = "60"
  records = ["${aws_db_instance.rds-instance.address}"]
}

output id{
  value = "${aws_db_instance.rds-instance.id}"
}
