variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}
variable "twitch_dns_access_key" {}
variable "twitch_dns_secret_key" {}

provider "aws" {
  access_key = "${var.twitch_aws_access_key}"
  #alias = "twitch_web_aws" # XXX AGB: terraform fails if this is uncommented. 2015-10-02
  region = "us-west-2"
  secret_key = "${var.twitch_aws_secret_key}"
}

variable "allocated_storage"{
  default = "150"
}

variable "engine"{
  default = "postgres"
}

variable "engine_version"{
  default = "9.5.2"
}

variable "instance_class"{
  default = "db.m3.xlarge"
}

variable "name"{
  default = "discovery"
}

variable "username"{
  default = "super"
}

variable "password"{
  default = "mypassword"
}

variable "db_subnet_group_name"{
  default = "discovery-staging-subnet"
}

variable "parameter_group_name"{
  default = "default.postgres9.5"
  #default = "discovery.9.5default"
}

variable "storage_type"{
  default = "gp2"
}

variable "environment"{
  default = "staging"
}

variable "multi_az"{
  default = "true"
}

variable "publicly_accessible"{
  default = "false"
}
variable "count"{
  default = "0"
}

variable "vpc_security_group_ids"{
  default = "sg-16680271"
}

variable "internal_zone_id"{
  default = "ZRG00SM48517Z"
}

variable "office_wifi"{
  default = "192.168.0.0/16,192.168.240.0/21,10.255.244.0/22,10.23.16.208/32" #office subnet, wifi, vpn
}

variable "service_cidrs" {
  default = "10.194.32.0/21,10.194.0.0/21,10.194.16.0/21"
}

variable "aws_account"{
  default = "twitch-web-dev"
}

module "common_local" {
  source = "../../../modules/variables/twitch-web-dev/"
}


module "discovery_staging_sg" {
  twitch_aws_access_key = "${var.twitch_aws_access_key}"
  twitch_aws_secret_key = "${var.twitch_aws_secret_key}"

  source = "../../../security_groups/lib/sg.rds.20160729/"

  cidrs = "${var.service_cidrs},${module.common_local.data_a_cidr},${module.common_local.data_b_cidr},${module.common_local.data_c_cidr},${var.office_wifi}"
  environment = "${var.environment}"
  sg_description = "security group for data-pg"
  sg_name = "rds security group"
  sg_project = "rds-d8a-security"
  vpc_id = "${module.common_local.vpc_id}"
}

module "discovery-master-0" {
  twitch_aws_access_key = "${var.twitch_aws_access_key}"
  twitch_aws_secret_key = "${var.twitch_aws_secret_key}"
  twitch_dns_access_key = "${var.twitch_dns_access_key}"
  twitch_dns_secret_key = "${var.twitch_dns_secret_key}"


  source = "../../lib/rds-master-prod.20160728/"

  allocated_storage    = "${var.allocated_storage}"
  engine               = "${var.engine}"
  engine_version       = "${var.engine_version}"
  instance_class       = "${var.instance_class}"
  dbname               = "${var.name}"
  environment          = "${var.environment}"
  identifier           = "${var.name}-${var.environment}-master"
  username             = "${var.username}"
  password             = "${var.password}"
  db_subnet_group_name = "${var.db_subnet_group_name}"
  #parameter_group_name = "${var.parameter_group_name}"
  storage_type         = "${var.storage_type}"
  multi_az             = "${var.multi_az}"
  publicly_accessible  = "${var.publicly_accessible}"
  backup_retention_period  = "7"
  vpc_security_group_ids = "${module.discovery_staging_sg.security_group_id}"
  backup_window        = "10:24-10:54"
  maintenance_window   = "wed:07:40-wed:08:10"
  internal_zone_id     = "${var.internal_zone_id}"
  apply_immediately    = "true"
  aws_account          = "${var.aws_account}"
  parameter_group_name = "discovery-staging-95"

}


