provider "aws" {
  region  = "us-west-2"
  profile = "twitch-aws"
}

provider "aws" {
  region  = "us-east-1"
  profile = "twitch-web-dev"
  alias   = "ue1"
}

provider "aws" {
  region  = "us-west-2"
  profile = "twitch-aws"
  alias   = "dns"
}

provider "aws" {
  region  = "us-west-2"
  profile = "twitch-web-dev"
  alias   = "uw2"

}


variable "aws_account" {
  default = "twitch-web-dev"
}

variable "environment" {
  default = "development"
}

variable "internal_zone_id" {
  default = "ZRG00SM48517Z"
}

variable "maintenance_window" {
  default = "mon:15:00-mon:15:30"
}
variable "monitoring_interval" {
  default = "60"
}

resource "aws_db_instance" "mrt-master" {
  allocated_storage = "500"
  auto_minor_version_upgrade = "true"
  backup_retention_period = "14"
  backup_window = "10:24-10:54"
  copy_tags_to_snapshot = "true"
  db_subnet_group_name = "d8a-subnet-group"
  engine = "postgres"
  engine_version = "9.5.4"
  identifier = "multi-region-test-master"
  instance_class = "db.m3.xlarge"
  iops = "5000"
  monitoring_interval = "${var.monitoring_interval}"
  monitoring_role_arn = "arn:aws:iam::465369119046:role/rds-monitoring-role"
  maintenance_window = "${var.maintenance_window}"
  multi_az = "true"
  name = "mrt"
  provider = "aws.uw2"
  skip_final_snapshot = "true"
  storage_type = "io1"
  #vpc_security_group_ids = ["sg-16680271"]

  username = "pg"
  password = "whatever"

  tags {
    Environment = "${var.environment}"
    Name = "multi-region-rds-test"
    Owner = "abrashears@twitch.tv"
    Project = "d8a-r-n-d"
  }
}

resource "aws_route53_record" "mrt-master-cname" {
  provider = "aws.dns"
  zone_id = "ZRG00SM48517Z"
  name = "${aws_db_instance.mrt-master.identifier}.${var.environment}.${var.aws_account}"
  type = "CNAME"
  ttl = "60"
  records = ["${aws_db_instance.mrt-master.address}"]
}

resource "aws_db_instance" "mrt-replica-remote" {
  allocated_storage = "${aws_db_instance.mrt-master.allocated_storage}"
  db_subnet_group_name = "d8a-subnet-group"
  engine = "${aws_db_instance.mrt-master.engine}"
  engine_version = "${aws_db_instance.mrt-master.engine_version}"
  identifier = "multi-region-test-replica-remote"
  instance_class = "${aws_db_instance.mrt-master.instance_class}"
  iops = "5000"
  monitoring_interval = "${var.monitoring_interval}"
  monitoring_role_arn = "arn:aws:iam::465369119046:role/rds-monitoring-role"
  maintenance_window = "${aws_db_instance.mrt-master.maintenance_window}"
  provider = "aws.ue1"
  replicate_source_db = "${aws_db_instance.mrt-master.arn}"
  skip_final_snapshot = "true"
  storage_type = "io1"

  tags {
    Environment = "development"
    Name = "multi-region-rds-test"
    Owner = "abrashears@twitch.tv"
    Project = "d8a-r-n-d"
  }
}

resource "aws_route53_record" "mrt-replica-remote-cname" {
  provider = "aws.dns"
  zone_id = "${var.internal_zone_id}"
  name = "${aws_db_instance.mrt-replica-remote.identifier}.${var.environment}.${var.aws_account}"
  type = "CNAME"
  ttl = "60"
  records = ["${aws_db_instance.mrt-replica-remote.address}"]
}
